var spec={"openapi":"3.0.1","info":{"title":"Erwin DI","description":"REST API Documentation of Erwin DI","version":"1.0"},"servers":[{"url":"/{contextpath}/","variables":{"contextpath":{"description":"Provide the application context path here","default":"erwinDISuite"}}}],"paths":{"/api/v1/metadatamanager/tables":{"get":{"tags":["Table"],"summary":"Get tables by IDs and fill options","description":"The method's purpose is to retrieve detailed information about table objects list by specifying the tableIds and fillOptions. To use this method, two parameters are mandatory: tableIds and fillOptions. The returned SMTable objects contains various details about the table, including tableName,\ntable definition, environment name in which the table is present, etc. The fillOptions parameter is used to specify what additional data should be included in each SMTable object.<br> The following values can be used for fillOptions:<br>\nAPIConstants.SMFillOptions#TABLE_INDEXES (Value: 1) - Include table indexes in the returned object. <br>APIConstants.SMFillOptions#TABLE_EXTENDED_PROPERTIES (Value: 4) - Include table extended properties in the returned object. <br>APIConstants.SMFillOptions#TABLE_COLUMNS (Value: 2) - Include columns in the returned table object.<br>\nFor example, if you want to retrieve the SMTable object with both table indexes and its columns, you would pass a value of 3 (1 for TABLE_INDEXES + 2 for TABLE_COLUMNS) as the fillOptions.<br>Note: Pagination is applied, and by default, 25 records are displayed per page.","operationId":"getTables","parameters":[{"name":"tableIds","in":"query","description":"Specify a comma-separated list of unique table IDs (e.g., 1, 2, 3)","required":true,"schema":{"type":"string"}},{"name":"fillOptions","in":"query","description":"Possible values: 1,2,4","required":false,"schema":{"type":"integer","format":"int32","default":0}},{"name":"page","in":"query","description":"By default, the first page is listed. To navigate through pages, use this parameter. If the value of the page is 0 or -1, it will retrieve the records on the first page only.","required":false,"schema":{"type":"integer","format":"int32","default":1}},{"name":"per_page","in":"query","description":"This parameter sets the number of records to be returned in a response. If the value of the per_page is 0 or -1, records will be returned based on the threshold value provided in the Application.properties file.","required":false,"schema":{"type":"integer","format":"int32","default":25}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"put":{"tags":["Table"],"summary":"Updates list of tables","description":"The function updates the single table object or list of tables for specified SMTable objects and useReferenceId. With environmentId, tableName, and tableId being mandatory in each table object The useReferenceId value for the ERWIN and CWM databases is true, whereas for other database types, it is false. If the function is executed successfully, it will return a RequestStatus object that contains the success or failure information.<br>Note: To update a single record, send only one JSON object in the input with the necessary keys and values.","operationId":"updateTables","parameters":[{"name":"useReferenceId","in":"query","required":false,"schema":{"type":"boolean"}}],"requestBody":{"content":{"application/json":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/SMTable"}}},"application/xml":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/SMTable"}}}},"required":true},"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"post":{"tags":["Table"],"summary":"Creates list of tables","description":"Creates a list of tables or a single table object. Providing table name, table type, and environmentId is mandatory in each table object. If the function is executed successfully, it will return a RequestStatus object which contains the success or failure information.<br> Note: To insert a single record, send only one JSON object in the input with the necessary keys and values.","operationId":"createTables","requestBody":{"content":{"application/json":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/SMTable"}}},"application/xml":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/SMTable"}}}},"required":true},"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"delete":{"tags":["Table"],"summary":"Delete tables","description":"Deletes single or multiple tables from the environments for the specified list of table IDs. If tables are deleted, all their associated data will also be deleted. If the function is executed successfully, it will return a RequestStatus object which contains the success or failure information.","operationId":"deleteTables","parameters":[{"name":"tableIds","in":"query","description":"Specify a comma-separated list of unique table IDs (e.g., 1, 2, 3)","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/v1/metadatamanager/systems":{"get":{"tags":["System"],"summary":"Get systems in a list format","description":"To obtain a list of all available systems in the Metadata Manager module or a specific list for given Ids. <br> Note: Pagination is applied, and by default, 25 records are displayed per page.","operationId":"getSystems","parameters":[{"name":"systemIds","in":"query","description":"Specify a comma-separated list of unique system IDs (e.g., 1, 2, 3) or leave it empty to retrieve all the available systems.","required":false,"schema":{"type":"string"}},{"name":"page","in":"query","description":"By default, the first page is listed. To navigate through pages, use this parameter. If the value of the page is 0 or -1, it will retrieve the records on the first page only.","required":false,"schema":{"type":"integer","format":"int32","default":1}},{"name":"per_page","in":"query","description":"This parameter sets the number of records to be returned in a response. If the value of the per_page is 0 or -1, records will be returned based on the threshold value provided in the Application.properties file.","required":false,"schema":{"type":"integer","format":"int32","default":25}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"put":{"tags":["System"],"summary":"Updates list of systems","description":"This method updates the single system object or list of systems for specified SMSystem objects, requiring systemId and systemName as mandatory, and all system details can be updated. If the function is executed successfully, it will return a RequestStatus object that contains the success or failure information. Note: To update a single record, send only one JSON object in the input with the necessary keys and values.","operationId":"updateSystems","requestBody":{"content":{"application/json":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/SMSystem"}}},"application/xml":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/SMSystem"}}}},"required":true},"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"post":{"tags":["System"],"summary":"Creates list of systems","description":"Creates a list of systems or a single system object. Providing system name is mandatory. If the function is executed successfully, it will return a RequestStatus object which contains the success or failure information. <br> Note: To insert a single record, send only one JSON object in the input with the necessary keys and values.","operationId":"createSystems","requestBody":{"content":{"application/json":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/SMSystem"}}},"application/xml":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/SMSystem"}}}},"required":true},"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"delete":{"tags":["System"],"summary":"Delete systems","description":"Deletes single or multiple systems for the specified list of system IDs. It deletes the systems only if they do not contain any environments or documents.\nassociated with it. If the function is executed successfully, it will return a RequestStatus object which contains the success or failure information.","operationId":"deleteSystems","parameters":[{"name":"systemIds","in":"query","description":"Specify a comma-separated list of unique system IDs (e.g., 1, 2, 3)","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/v1/metadatamanager/environments":{"get":{"tags":["Environment"],"summary":"Get environments by IDs and fill options","description":"The method returns a list of SMEnvironment objects based on specified environmentIds. The environmentIds parameter is mandatory, meaning it must be provided when calling the method.\nThe method returns various details related to the environments, including : environmentId, environmentName, environmentType, systemId, systemName and other database-related details such as userName, password, and dbDriver information.\nThe fill options parameter is used to specify what additional data should be returned within each SMEnvironment object.\nThe value for fill options is expected to be one of the constants defined in the APIConstants.SMFillOptions class. The following values can be used to define fill options:<br>APIConstants.SMFillOptions#ENVIRONMENT_TABLES_COLUMNS(Value 256): Includes tables and columns in the returned environment object.<br>\nIf you want to retrieve the environment object with both tables and columns, including their extended properties, you would pass a value of 276 (256 for ENVIRONMENT_TABLES_COLUMNS + 4 TABLE_EXTENDED_PROPERTIES + 16 for COLUMN_EXTENDED_PROPERTIES) as the fill options.\nDepending on the value passed as fill options, related data is included in the SMEnvironment object.\nThe default value for fill options is 0 (zero), indicating that no additional data beyond the basic details is included.<br>\nNote: Pagination is applied, and by default, 25 records are displayed per page.","operationId":"getEnvironments","parameters":[{"name":"environmentIds","in":"query","description":"Specify a comma-separated list of unique environment IDs (e.g., 1, 2, 3).","required":true,"schema":{"type":"string"}},{"name":"fillOptions","in":"query","description":"Possible values: 256, 276","required":false,"schema":{"type":"integer","format":"int32","default":0}},{"name":"useReferenceId","in":"query","required":false,"schema":{"type":"boolean"}},{"name":"page","in":"query","description":"By default, the first page is listed. To navigate through pages, use this parameter. If the value of the page is 0 or -1, it will retrieve the records on the first page only.","required":false,"schema":{"type":"integer","format":"int32","default":1}},{"name":"per_page","in":"query","description":"This parameter sets the number of records to be returned in a response. If the value of the per_page is 0 or -1, records will be returned based on the threshold value provided in the Application.properties file.","required":false,"schema":{"type":"integer","format":"int32","default":25}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"put":{"tags":["Environment"],"summary":"Updates list of environments","description":"This function is used to update the list of environments for a specified list of SMEnvironment objects. Note that when updating an environment, it is possible to change the database type from one type to another. However, depending on the database type, certain details must be specified. For instance, if the database type of the environment is ETL, it is not possible to update the environment from one database type to another or vice versa.<br>\nIf the function is executed successfully, it will return a RequestStatus object that contains the success or failure information.<br> Note: To update a single record, send only one JSON object in the input with the necessary keys and values.","operationId":"updateEnvironments","requestBody":{"content":{"application/json":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/SMEnvironment"}}},"application/xml":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/SMEnvironment"}}}},"required":true},"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"post":{"tags":["Environment"],"summary":"Creates list of environments","description":"This function creates a new system environment or list of environments for a specified list of SMEnvironment objects. You must provide the environment name and database type. Additionally, fields such as driver name, username, password, dbms name, port, URL, and IP address are also mandatory. However, if the database type is of file type, you do not need to specify the driver name, port, URL, etc.\nIf the function is executed successfully, it will return a RequestStatus object that contains the success or failure information. Note: To insert a single record, send only one JSON object in the input with the necessary keys and values.","operationId":"createEnvironments","requestBody":{"content":{"application/json":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/SMEnvironment"}}},"application/xml":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/SMEnvironment"}}}},"required":true},"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"delete":{"tags":["Environment"],"summary":"Delete environments","description":"Deletes single or multiple environments from the systems for the specified list of environment IDs. Use version mode to delete all environments or just the current version. If versionMode is not specified, the current version environment will be deleted. If the environments are deleted, all their associated data will also be deleted. If the function is executed successfully, it will return a RequestStatus object which contains the success or failure information.","operationId":"deleteEnvironments","parameters":[{"name":"environmentIds","in":"query","description":"Specify a comma-separated list of unique encironment IDs (e.g., 1, 2, 3)","required":true,"schema":{"type":"string"}},{"name":"versionMode","in":"query","required":true,"schema":{"type":"string","enum":["ALL_VERSIONS","CURRENT_VERSION","SPECIFIC_VERSION"]}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/v1/metadatamanager/columns":{"get":{"tags":["Column"],"summary":"Get columns by IDs and fill options.","description":"The method's purpose is to retrieve detailed information about column objects list by specifying the columnIds and fillOptions. To use this method, two parameters are mandatory: columnIds and fillOptions. It returns a list of column objects, where each column object contains various details such as column name, column data type, column length, column precision, and more.\nThe fillOptions parameter is used to specify what additional data should be included in each SMColumn object. The following values can be used for fillOptions:<br>\nAPIConstants.SMFillOptions#COLUMN_INDEXES (Value: 8) - Include column indexes in the returned object.<br>APIConstants.SMFillOptions#COLUMN_EXTENDED_PROPERTIES (Value: 16) - Include column extended properties in the returned object.<br>APIConstants.SMFillOptions#COLUMN_VALID_VALUES (Value: 32) - Include valid values for the column.<br>APIConstants.SMFillOptions#VALID_VALUES_EXTENDED_PROPERTIES (Value: 64) - Include extended properties of valid values. <br>Depending on the combination of values passed in the fillOptions parameter, the returned SMColumn object will contain different sets of related data.\nFor example, if you want to retrieve the SMColumn object with both column indexes and column extended properties, you would pass a value of 24 (8 for COLUMN_INDEXES + 16 for COLUMN_EXTENDED_PROPERTIES) as the fillOptions. <br>The default value for fillOptions is 0 (zero), indicating that no additional data beyond the basic details is included.<br>\nNote: Pagination is applied, and by default, 25 records are displayed per page.","operationId":"getColumns","parameters":[{"name":"columnIds","in":"query","description":"Specify a comma-separated list of unique column IDs (e.g., 1, 2, 3).","required":true,"schema":{"type":"string"}},{"name":"fillOptions","in":"query","description":"Possible values: 8,16,32,64","required":false,"schema":{"type":"integer","format":"int32","default":0}},{"name":"page","in":"query","description":"By default, the first page is listed. To navigate through pages, use this parameter. If the value of the page is 0 or -1, it will retrieve the records on the first page only.","required":false,"schema":{"type":"integer","format":"int32","default":1}},{"name":"per_page","in":"query","description":"This parameter sets the number of records to be returned in a response. If the value of the per_page is 0 or -1, records will be returned based on the threshold value provided in the Application.properties file.","required":false,"schema":{"type":"integer","format":"int32","default":25}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"put":{"tags":["Column"],"summary":"Updates list of columns","description":"Updates the columns list or single column object, to update SMColumn objects, provide tableId, columnId, and columnName for each object to ensure proper update. If the function is executed successfully, it will return a RequestStatus object that contains the success or failure information.<br> Note: To update a single record, send only one JSON object in the input with the necessary keys and values.","operationId":"updateColumns","parameters":[{"name":"useReferenceId","in":"query","required":false,"schema":{"type":"boolean"}}],"requestBody":{"content":{"application/json":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/SMColumn"}}},"application/xml":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/SMColumn"}}}},"required":true},"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"post":{"tags":["Column"],"summary":"Creates list of columns","description":"Creates a list of columns or a single column object. Each column object requires information about the tableId and column name to be created under that specific table. If the function is executed successfully, it will return a RequestStatus object which contains the success or failure information.<br> Note: To insert a single record, send only one JSON object in the input with the necessary keys and values.","operationId":"createColumns","requestBody":{"content":{"application/json":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/SMColumn"}}},"application/xml":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/SMColumn"}}}},"required":true},"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"delete":{"tags":["Column"],"summary":"Delete columns","description":"Deletes single or multiple columns from the tables for the specified list of column IDs. If the columns are deleted, all their associated data will also be deleted. If the function is executed successfully, it will return a RequestStatus object which contains the success or failure information.","operationId":"deleteColumns","parameters":[{"name":"columnIds","in":"query","description":"Specify a comma-separated list of unique column IDs (e.g., 1, 2, 3)","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/miscellaneous/tags":{"get":{"tags":["Tag"],"summary":"Get tags in a list format.","description":"To obtain a list of all available tags in master configuration or a specific list for given Ids. <br> Note: Pagination is applied, and by default, 25 records are displayed per page.","operationId":"getTags","parameters":[{"name":"tagIds","in":"query","description":"Enter a comma-separated list of unique tag IDs(e.g., 1, 2, 3) or leave it empty to retrieve all tags from the master configuration.","required":false,"schema":{"type":"string"}},{"name":"page","in":"query","description":"By default, the first page is listed. To navigate through pages, use this parameter. If the value of the page is 0 or -1, it will retrieve the records on the first page only.","required":false,"schema":{"type":"integer","format":"int32","default":1}},{"name":"per_page","in":"query","description":"This parameter sets the number of records to be returned in a response. If the value of the per_page is 0 or -1, records will be returned based on the threshold value provided in the Application.properties file.","required":false,"schema":{"type":"integer","format":"int32","default":25}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"put":{"tags":["Tag"],"summary":"Updates list of tags","description":"This function allows you to update the list of tags for a specific set of tag objects. You can modify all information related to the tags, but you must provide the tag ID, tag name and scopeObjectTypes list for each tag object you want to update. The object names listed in the scopeObjectTypes list should match the object names displayed in the Enterprise tags master configuration.","operationId":"updateTags","requestBody":{"content":{"application/json":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/Tag"}}},"application/xml":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/Tag"}}}},"required":true},"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"post":{"tags":["Tag"],"summary":"Add list of tags","description":"To add a new tag, you need to provide all the details about the tag, such as the name, description, scopeObjectTypes, and more. It is mandatory to specify the tag name and scopeObjectTypes list. The object names in the scopeObjectTypes list should be the same as the one displayed in the master configuration of Enterprise tags.","operationId":"addTags","requestBody":{"content":{"application/json":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/Tag"}}},"application/xml":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/Tag"}}}},"required":true},"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"delete":{"tags":["Tag"],"summary":"Delete list of tags.","description":"It is mandatory to specify the list of tagIds to remove tags. Tags will only be deleted if they are not associated with any objects.","operationId":"deleteTags","parameters":[{"name":"tagIds","in":"query","description":"Specify a comma-separated list of unique tag IDs (e.g., 1, 2, 3)","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/miscellaneous/associations":{"get":{"tags":["Association"],"summary":"Get associations list by IDs","description":"To retrieve a list of association objects, you must provide a list of association IDs. It is mandatory to provide this list. The parameter \"fillInfo\" can be set to either true or false. If it is set to true, the association object will be returned with both the source and target objects filled in with details. If it is set to false, only the association details will be returned. Note: Pagination is applied, and by default, 25 records are displayed per page.","operationId":"getAssociations","parameters":[{"name":"associationIds","in":"query","description":"Specify a comma-separated list of unique association IDs (e.g., 1, 2, 3)","required":true,"schema":{"type":"string"}},{"name":"fillInfo","in":"query","description":"Whether to include source and target object details or not","required":false,"schema":{"type":"boolean"}},{"name":"page","in":"query","description":"By default, the first page is listed. To navigate through pages, use this parameter. If the value of the page is 0 or -1, it will retrieve the records on the first page only.","required":false,"schema":{"type":"integer","format":"int32","default":1}},{"name":"per_page","in":"query","description":"This parameter sets the number of records to be returned in a response. If the value of the per_page is 0 or -1, records will be returned based on the threshold value provided in the Application.properties file.","required":false,"schema":{"type":"integer","format":"int32","default":25}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"put":{"tags":["Association"],"summary":"Updates list of associations","description":"This function is used to update the fields(Extended Properties) for the list of associations. Specifying the associationId in each association object is mandatory while updating the association.","operationId":"updateAssociations","requestBody":{"content":{"application/json":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/Association"}}},"application/xml":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/Association"}}}},"required":true},"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"post":{"tags":["Association"],"summary":"Creates list of associations","description":"Creates the associations for the given source and target object details. Specifying the sourceObjectId, sourceObjectTypeId, targetObjectId, targetObjectTypeId, relationshipType, and either the titleForward or titleReverse is mandatory while creating the association.","operationId":"createAssociations","requestBody":{"content":{"application/json":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/Association"}}},"application/xml":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/Association"}}}},"required":true},"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"delete":{"tags":["Association"],"summary":"Delete associations for object.","description":"Deletes all the associations of an object for the selected nodeType and given objectIds. Specifying the nodeType and objectIds is mandatory.","operationId":"deleteAssociations","parameters":[{"name":"nodeType","in":"query","description":"Select the nodeType to delete associations","required":true,"schema":{"type":"string","enum":["SM_SYSTEM","SM_ENVIRONMENT","SM_TABLE","SM_COLUMN","BGM_TERM","BGM_RULE","BGM_POLICY","BGM_CUSTOM"]}},{"name":"objectIds","in":"query","description":"Specify a comma-separated list of unique object IDs (e.g., 1, 2, 3)","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/mappingmanager/subjects":{"get":{"tags":["Subject"],"summary":"Get subjects list","description":"This function retrieves the list of subjects corresponding to the given subjectIds.<br>Note: Pagination is applied, and by default, 25 records are displayed per page.","operationId":"getSubjects","parameters":[{"name":"subjectIds","in":"query","description":"Specify a comma-separated list of unique subject IDs (e.g., 1, 2, 3).","required":true,"schema":{"type":"string"}},{"name":"page","in":"query","description":"By default, the first page is listed. To navigate through pages, use this parameter. If the value of the page is 0 or -1, it will retrieve the records on the first page only.","required":false,"schema":{"type":"integer","format":"int32","default":1}},{"name":"per_page","in":"query","description":"This parameter sets the number of records to be returned in a response. If the value of the per_page is 0 or -1, records will be returned based on the threshold value provided in the Application.properties file.","required":false,"schema":{"type":"integer","format":"int32","default":25}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"put":{"tags":["Subject"],"summary":"Updates list of subjects","description":"Updates the subjects list or single subject object, which requires subjectId, projectId and subjectName. If the function is executed successfully, it will return a RequestStatus object that contains the success or failure information.<br>Note: To update a single record, send only one JSON object in the input with the necessary keys and values.","operationId":"updateSubjects","requestBody":{"content":{"application/json":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/Subject"}}},"application/xml":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/Subject"}}}},"required":true},"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"post":{"tags":["Subject"],"summary":"Creates list of subjects","description":"Creates a list of subjects or a single subject object. Providing projectId and subjectName is mandatory. If the function is executed successfully, it will return a RequestStatus object that contains the success or failure information.<br>Note: To insert a single record, send only one JSON object in the input with the necessary keys and values.","operationId":"createSubjects","requestBody":{"content":{"application/json":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/Subject"}}},"application/xml":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/Subject"}}}},"required":true},"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"delete":{"tags":["Subject"],"summary":"Delete subjects","description":"The list of subjects for the specified subjectIds will be deleted. If the function is executed successfully, it will return a RequestStatus object that contains the success or failure information.","operationId":"deleteSubjects","parameters":[{"name":"subjectIds","in":"query","description":"Specify a comma-separated list of unique subject IDs (e.g., 1, 2, 3)","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/mappingmanager/projects":{"get":{"tags":["Project"],"summary":"Get projects list","description":"To obtain a list of all available projects in the Mapping Manager module or a specific list for given Ids. Note: Pagination is applied, and by default, 25 records are displayed per page.","operationId":"getProjects","parameters":[{"name":"projectIds","in":"query","description":"Specify a comma-separated list of unique project IDs (e.g., 1, 2, 3) or leave it empty to retrieve all the available projects","required":false,"schema":{"type":"string"}},{"name":"page","in":"query","description":"By default, the first page is listed. To navigate through pages, use this parameter. If the value of the page is 0 or -1, it will retrieve the records on the first page only.","required":false,"schema":{"type":"integer","format":"int32","default":1}},{"name":"per_page","in":"query","description":"This parameter sets the number of records to be returned in a response. If the value of the per_page is 0 or -1, records will be returned based on the threshold value provided in the Application.properties file..","required":false,"schema":{"type":"integer","format":"int32","default":25}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"put":{"tags":["Project"],"summary":"Updates list of projects","description":"Updates the projects list or single project object, which requires projectId and projectName. If the function is executed successfully, it will return a RequestStatus object that contains the success or failure information. <br>Note: To update a single record, send only one JSON object in the input with the necessary keys and values.","operationId":"updateProjects","requestBody":{"content":{"application/json":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/Project"}}},"application/xml":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/Project"}}}},"required":true},"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"post":{"tags":["Project"],"summary":"Creates list of projects","description":"Creates a list of projects or a single project object. Providing project name is mandatory. If the function is executed successfully, it will return a RequestStatus object that contains the success or failure information. <br>Note: To insert a single record, send only one JSON object in the input with the necessary keys and values.","operationId":"createProjects","requestBody":{"content":{"application/json":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/Project"}}},"application/xml":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/Project"}}}},"required":true},"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"delete":{"tags":["Project"],"summary":"Delete projects","description":"The list of projects for the specified projectIds will be deleted. If the function is executed successfully, it will return a RequestStatus object that contains the success or failure information.","operationId":"deleteProjects","parameters":[{"name":"projectIds","in":"query","description":"Specify a comma-separated list of unique project IDs (e.g., 1, 2, 3)","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/mappingmanager/mappings":{"get":{"tags":["Mapping"],"summary":"Get mappings by IDs and fill options","description":"To obtain a list of all mappings for a given set of IDs and fill options. The fill options parameter is used to specify what additional data should be included in each mapping object.<br> The following values can be used for fill options:<br>\nAPIConstants.MMFillOptions #MAPPING_SPECIFICATIONS (Value 1): include mapping specifications in the returned object.<br> APIConstants.MMFillOptions#MAPPING_DOCUMENTS(Value 2): include mapping documents in the returned object.<br>\nDepending on the combination of values passed in the fill options parameter, each returned mapping object will contain different sets of related data. For example, if you want to retrieve the mapping object with both mapping specifications and mapping documents, you would pass a value of 3 (1 for MAPPING_SPECIFICATIONS + 2 for MAPPING_DOCUMENTS) as the fill options. The default value for fill options is 0 (zero), indicating that no additional data beyond the basic details is included.<br>\nNote: Pagination is applied, and by default, 25 records are displayed per page.","operationId":"getMappings","parameters":[{"name":"mappingIds","in":"query","description":"Specify a comma-separated list of unique mapping IDs (e.g., 1, 2, 3).","required":true,"schema":{"type":"string"}},{"name":"fillOptions","in":"query","description":"Possible values: 1,2","required":false,"schema":{"type":"integer","format":"int32","default":0}},{"name":"page","in":"query","description":"By default, the first page is listed. To navigate through pages, use this parameter. If the value of the page is 0 or -1, it will retrieve the records on the first page only.","required":false,"schema":{"type":"integer","format":"int32","default":1}},{"name":"per_page","in":"query","description":"This parameter sets the number of records to be returned in a response. If the value of the per_page is 0 or -1, records will be returned based on the threshold value provided in the Application.properties file.","required":false,"schema":{"type":"integer","format":"int32","default":25}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"put":{"tags":["Mapping"],"summary":"Updates list of mappings","description":"Updates the mappings list or single mapping object, which requires projectId, mappingId and mapingName. If the function is executed successfully, it will return a RequestStatus object that contains the success or failure information.<br> Note: To update a single record, send only one JSON object in the input with the necessary keys and values.","operationId":"updateMappings","requestBody":{"content":{"application/json":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/Mapping"}}},"application/xml":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/Mapping"}}}},"required":true},"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"post":{"tags":["Mapping"],"summary":"Creates list of mappings with fill options","description":"Creates mappings for specified mapping objects and fill options, requiring project ID, subject ID, and mapping name in each mapping object. The fill options parameter is an optional parameter used to specify the additional data required to add along with each mapping object. To define the additional data, we can use the constants defined in the APIConstants.MMFillOptions class.<br> The following values can be used to define fill options: <br> APIConstants.MMFillOptions#MAPPING_SPECIFICATIONS (Value 1): Adds mapping specifications together with mapping objects. <br>APIConstants.MMFillOptions#MAPPING_DOCUMENTS (Value 2): Adds mapping documents together with mapping objects. <br>APIConstants.MMFillOptions#MAPPING_EXTENDED_PROPERTIES (Value 4): Adds extended properties together with mapping objects.<br>\nYou can add different sets of related data depending on the combination of values passed in the fill options parameter. For instance, to add the mapping object with both mapping specifications and mapping documents, you would pass a value of 3 (1 for MAPPING_SPECIFICATIONS + 2 for MAPPING_DOCUMENTS) as the fill options. The default value for fill options is 0, which means that no additional data beyond the basic details is added.<br>\nIf the function is executed successfully, it will return a RequestStatus object that contains the success or failure information. <br>Note: To insert a single record, send only one JSON object in the input with the necessary keys and values.","operationId":"createMapping","parameters":[{"name":"fillOptions","in":"query","description":"Possible values: 1,2,4","required":false,"schema":{"type":"integer","format":"int32","default":0}}],"requestBody":{"content":{"application/json":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/Mapping"}}},"application/xml":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/Mapping"}}}},"required":true},"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"delete":{"tags":["Mapping"],"summary":"Delete mappings ","description":"The function deletes the mappings of specified mappingIds and version mode which are mandatory.  Current version  mapping will be deleted if versionMode is not specified. If the versionMode is SPECIFIC_VERSION, specification of versionNo is mandatory.\nIf the function is executed successfully, it will return a RequestStatus object that contains the success or failure information.","operationId":"deleteMappings","parameters":[{"name":"mappingIds","in":"query","description":"Specify a comma-separated list of unique mapping IDs (e.g., 1, 2, 3)","required":true,"schema":{"type":"string"}},{"name":"versionMode","in":"query","description":"Select the version mode","required":true,"schema":{"type":"string","enum":["ALL_VERSIONS","CURRENT_VERSION","SPECIFIC_VERSION"]}},{"name":"versionNo","in":"query","description":"Provide the version number if the version mode is a specific version","required":false,"schema":{"type":"number","format":"float","default":0.0}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/mappingmanager/mappings/specifications":{"get":{"tags":["Mapping"],"summary":"Get mapping specifications using mappingSequenceIds.","description":"To obtain a list of mapping specification rows for the specified list of mappingSequenceIds. Note: Pagination is applied, and by default, 25 records are displayed per page.","operationId":"getMappingSpecifications","parameters":[{"name":"mappingSequenceIds","in":"query","description":"Specify a comma-separated list of unique mapping sequence IDs (e.g., 1, 2, 3))","required":true,"schema":{"type":"string"}},{"name":"page","in":"query","description":"By default, the first page is listed. To navigate through pages, use this parameter. If the value of the page is 0 or -1, it will retrieve the records on the first page only.","required":false,"schema":{"type":"integer","format":"int32","default":1}},{"name":"per_page","in":"query","description":"This parameter sets the number of records to be returned in a response. If the value of the per_page is 0 or -1, records will be returned based on the threshold value provided in the Application.properties file.","required":false,"schema":{"type":"integer","format":"int32","default":25}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"put":{"tags":["Mapping"],"summary":"Updates list of mapping specifications","description":"Update mapping specifications by providing mapSequenceIds and mapping specification row objects. Ensure that each mapping specification row object includes a mappingId. If the function is executed successfully, it will return a RequestStatus object that contains the success or failure information.<br> Note: To update a single record, send only one JSON object in the input with the necessary keys and values.","operationId":"updateMappingSpecifications","requestBody":{"content":{"application/json":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/MappingSpecificationRow"}}},"application/xml":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/MappingSpecificationRow"}}}},"required":true},"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"post":{"tags":["Mapping"],"summary":"Inserts mapping specifications","description":"The specified mappingId will have a list of mappingSpecifications inserted into it. If the function is executed successfully, it will return a RequestStatus object that contains the success or failure information.<br> Note: To insert a single record, send only one JSON object in the input with the necessary keys and values.","operationId":"addMappingSpecifications","parameters":[{"name":"mappingId","in":"query","description":"ID of the mapping to add specifications","required":true,"schema":{"type":"integer","format":"int32"}}],"requestBody":{"content":{"application/json":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/MappingSpecificationRow"}}},"application/xml":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/MappingSpecificationRow"}}}},"required":true},"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"delete":{"tags":["Mapping"],"summary":"Delete mapping specifications","description":"In order to delete the mapping specifications, it is necessary to provide the list of mappingSequenceIds. If the function is executed successfully, it will return a RequestStatus object that contains the success or failure information.","operationId":"deleteMappingSpecifications","parameters":[{"name":"mappingSequenceIds","in":"query","description":"Specify a comma-separated list of unique mapping sequence IDs (e.g., 1, 2, 3)","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/businessglossarymanager/catalogs":{"get":{"tags":["Catalog"],"summary":"Get catalogs by IDs and fill options","description":"The function returns all the details, like catalogName, parentCatalogId, catalogTypeId and auditHistory details of the catalog objects for the given catalog IDs and fill options. The fill options parameter is an optional parameter that helps specify additional data needed for each catalog object. We can define this data by using constants defined in the APIConstants.BGMFillOptions class.<br> The following values can be used to define fill options:<br>\nAPIConstants.BGMFillOptions#CATALOG_EXTENDED_PROPERTIES (Value 1): This includes extended properties in the returned catalog objects.<br> The default value for fill options is 0, which means that no additional data beyond the basic details is returned. <br> Note: Pagination is applied, and by default, 25 records are displayed per page.","operationId":"getCatalogs","parameters":[{"name":"catalogIds","in":"query","description":"Specify a comma-separated list of unique catalog IDs (e.g., 1, 2, 3)","required":false,"schema":{"type":"string"}},{"name":"fillOptions","in":"query","description":"Possible values: 0 or 1","required":false,"schema":{"type":"integer","format":"int32","default":0}},{"name":"page","in":"query","description":"By default, the first page is listed. To navigate through pages, use this parameter. If the value of the page is 0 or -1, it will retrieve the records on the first page only.","required":false,"schema":{"type":"integer","format":"int32","default":1}},{"name":"per_page","in":"query","description":"This parameter sets the number of records to be returned in a response. If the value of the per_page is 0 or -1, records will be returned based on the threshold value provided in the Application.properties file.","required":false,"schema":{"type":"integer","format":"int32","default":25}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"put":{"tags":["Catalog"],"summary":"Updates list of catalogs with fill options","description":"This function updates the list of catalogs for the provided catalog objects. All the details of the catalog  can be updated. To update a catalog, it is mandatory to specify both the catalogId and catalogName within the corresponding catalog object. The fill options parameter is an optional parameter used to specify the additional data required to update along with each catalog object. To define the additional data, we can use the constants defined in the APIConstants.BGMFillOptions class. The following values can be used to define fill options:<br>\nAPIConstants.BGMFillOptions#CATALOG_EXTENDED_PROPERTIES (Value 1): Updates extended properties together with catalog objects.<br> Depending on the value passed as fill options, related data is updated in the catalog object. The default value for fillOptions is 0, which means that no additional data beyond the basic details is updated. <br>If the function is executed successfully, it will return a RequestStatus object that contains the success or failure information. <br> Note: To insert a single record, send only one JSON object in the input with the necessary keys and values.","operationId":"updateCatalogs","parameters":[{"name":"fillOptions","in":"query","description":"Possible values: 1","required":false,"schema":{"type":"integer","format":"int32","default":0}}],"requestBody":{"content":{"application/json":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/Catalog"}}},"application/xml":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/Catalog"}}}},"required":true},"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"post":{"tags":["Catalog"],"summary":"Creates list of catalogs with fill options","description":"This function is used to create a list of catalogs based on the provided catalog objects. When creating a catalog object, it is required to include the catalogName and catalogTypeId. If you're creating a subcatalog, then you must specify the parentCatalogId. The fill options parameter is an optional parameter used to specify the additional data required to add along with each catalog object. To define the additional data, we can use the constants defined in the APIConstants.BGMFillOptions class. The following values can be used to define fill options:<br> APIConstants.BGMFillOptions#CATALOG_EXTENDED_PROPERTIES (Value 1):  Adds extended properties together with catalog objects.<br> Depending on the value passed as fill options, related data is included in the catalog object. The default value for fillOptions is 0, which means that no additional data beyond the basic details is added. <br>If the function is executed successfully, it will return a RequestStatus object that contains the success or failure information. <br> Note: To insert a single record, send only one JSON object in the input with the necessary keys and values.","operationId":"createCatalogs","parameters":[{"name":"fillOptions","in":"query","description":"Possible values: 1","required":false,"schema":{"type":"integer","format":"int32","default":0}}],"requestBody":{"content":{"application/json":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/Catalog"}}},"application/xml":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/Catalog"}}}},"required":true},"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"delete":{"tags":["Catalog"],"summary":"Delete catalogs.","description":"Deletes single or multiple catalogs. To delete a list of catalogs, provide catalog IDs list with a comma separator. If the catalogs are deleted all their associated data will also be deleted. If the function is executed successfully, it will return a RequestStatus object that contains the success or failure information.","operationId":"deleteCatalogs","parameters":[{"name":"nodeType","in":"query","description":"Select the node Type.","required":true,"schema":{"type":"string","enum":["BGM_TERM","BGM_RULE","BGM_POLICY","BGM_CUSTOM"]}},{"name":"catalogIds","in":"query","description":"Specify a comma-separated list of unique catalog IDs (e.g., 1, 2, 3).","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/businessglossarymanager/assets":{"get":{"tags":["Business Asset"],"summary":"Get business assets list","description":"The function returns a list of business assets for specified businessAssetIds and node types, with businessAssetIds based on the node type. NodeType options can be either BGM_TERM, BGM_RULE, BGM_POLICY, or BGM_CUSTOM. Depending on the node type, businessAssetId will be either a business term, policy, rule, or custom object's ID.<br>Note: Pagination is applied, and by default, 25 records are displayed per page.","operationId":"getBusinessAssets","parameters":[{"name":"nodeType","in":"query","description":"Select the nodeType to retrieve business assets","required":true,"schema":{"type":"string","enum":["BGM_TERM","BGM_RULE","BGM_POLICY","BGM_CUSTOM"]}},{"name":"businessAssetIds","in":"query","description":"Specify a comma-separated list of unique business asset IDs (e.g., 1, 2, 3)","required":true,"schema":{"type":"string"}},{"name":"page","in":"query","description":"By default, the first page is listed. To navigate through pages, use this parameter. If the value of the page is 0 or -1, it will retrieve the records on the first page only..","required":false,"schema":{"type":"integer","format":"int32","default":1}},{"name":"per_page","in":"query","description":"This parameter sets the number of records to be returned in a response. If the value of the per_page is 0 or -1, records will be returned based on the threshold value provided in the Application.properties file.","required":false,"schema":{"type":"integer","format":"int32","default":25}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"put":{"tags":["Business Asset"],"summary":"Updates list of business assets","description":"This function updates the business assets based on the provided list of assets (businessObjects list). The business assets can be either Business Terms, Business Policies, Business Rules, or Custom Objects. If the function is executed successfully, it will return a RequestStatus object that contains the success or failure information.<br>Note: To update a single record, send only one JSON object in the input with the necessary keys and values.","operationId":"updateBusinessAssets","requestBody":{"content":{"application/json":{"schema":{"type":"array","items":{"oneOf":[{"$ref":"#/components/schemas/BusinessObject"},{"$ref":"#/components/schemas/BusinessPolicy"},{"$ref":"#/components/schemas/BusinessRule"},{"$ref":"#/components/schemas/BusinessTerm"},{"$ref":"#/components/schemas/CustomObject"}]}}},"application/xml":{"schema":{"type":"array","items":{"oneOf":[{"$ref":"#/components/schemas/BusinessObject"},{"$ref":"#/components/schemas/BusinessPolicy"},{"$ref":"#/components/schemas/BusinessRule"},{"$ref":"#/components/schemas/BusinessTerm"},{"$ref":"#/components/schemas/CustomObject"}]}}}},"required":true},"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"post":{"tags":["Business Asset"],"summary":"Creates list of business assets","description":"This function generates business assets based on the input list of objects provided. The business assets can be either Business Terms, Business Policies, Business Rules, or Custom Objects. It is essential to include the nodeType, objectName, and catalogTypeId in each businessObject. If the function is executed successfully, it will return a RequestStatus object that contains the success or failure information. <br> Note: To insert a single record, send only one JSON object in the input with the necessary keys and values.","operationId":"createBusinessAssets","requestBody":{"content":{"application/json":{"schema":{"type":"array","items":{"oneOf":[{"$ref":"#/components/schemas/BusinessObject"},{"$ref":"#/components/schemas/BusinessPolicy"},{"$ref":"#/components/schemas/BusinessRule"},{"$ref":"#/components/schemas/BusinessTerm"},{"$ref":"#/components/schemas/CustomObject"}]}}},"application/xml":{"schema":{"type":"array","items":{"oneOf":[{"$ref":"#/components/schemas/BusinessObject"},{"$ref":"#/components/schemas/BusinessPolicy"},{"$ref":"#/components/schemas/BusinessRule"},{"$ref":"#/components/schemas/BusinessTerm"},{"$ref":"#/components/schemas/CustomObject"}]}}}},"required":true},"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"delete":{"tags":["Business Asset"],"summary":"Delete business assets","description":"To delete business objects, provide a list of businessAssetIds and nodeType. If the business objects are deleted, all their associated data will also be lost. The nodeType can be either BGM_TERM, BGM_RULE, BGM_POLICY, or BGM_CUSTOM. Depending on the nodeType, businessAssetIds will be either a term, policy, rule, or custom object IDs. If the function is executed successfully, it will return a RequestStatus object that contains the success or failure information.","operationId":"deleteObjects","parameters":[{"name":"nodeType","in":"query","description":"Select the node Type.","required":true,"schema":{"type":"string","enum":["BGM_TERM","BGM_RULE","BGM_POLICY","BGM_CUSTOM"]}},{"name":"businessAssetIds","in":"query","description":"Specify a comma-separated list of unique business asset IDs (e.g., 1, 2, 3)","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/businessglossarymanager/assets/types":{"get":{"tags":["Asset Type"],"summary":"Get asset types list","description":"The function returns all the details, like ID, name, description, and title, of the asset type objects for the given assetTypeIds with a comma separator.<br> Note: Pagination is applied, and by default, 25 records are displayed per page.","operationId":"getAssetTypes","parameters":[{"name":"assetTypeIds","in":"query","description":"Enter a comma-separated list of unique assetType IDs(e.g., 1, 2, 3) or leave it empty to retrieve all the available assetTypes.","required":false,"schema":{"type":"string"}},{"name":"page","in":"query","description":"By default, the first page is listed. To navigate through pages, use this parameter. If the value of the page is 0 or -1, it will retrieve the records on the first page only.","required":false,"schema":{"type":"integer","format":"int32","default":1}},{"name":"per_page","in":"query","description":"This parameter sets the number of records to be returned in a response. If the value of the per_page is 0 or -1, records will be returned based on the threshold value provided in the Application.properties file.","required":false,"schema":{"type":"integer","format":"int32","default":25}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"put":{"tags":["Asset Type"],"summary":"Updates list of asset types","description":"To update asset type objects, provide the ID, name, and title for each object, and all relevant information can be updated. If the function is executed successfully, it will return a RequestStatus object that contains the success or failure information.<br>Note: To update a single record, send only one JSON object in the input with the necessary keys and values.","operationId":"updateAssetTypes","requestBody":{"content":{"application/json":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/AssetType"}}},"application/xml":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/AssetType"}}}},"required":true},"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"post":{"tags":["Asset Type"],"summary":"Creates list of assets types","description":"To create the asset types in the business glossary module, it is necessary to provide the name and title. The asset type will only be displayed in the Business Glossary module when the \"enabled\" value is set to true. If the function is executed successfully, it will return a RequestStatus object that contains the success or failure information.<br>Note: To insert a single record, send only one JSON object in the input with the necessary keys and values.","operationId":"createAssetTypes","requestBody":{"content":{"application/json":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/AssetType"}}},"application/xml":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/AssetType"}}}},"required":true},"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]},"delete":{"tags":["Asset Type"],"summary":"Delete asset types","description":"The specification-based deletion process allows for the removal of either a single asset type or a list of asset types. When deleting a list, it is required that assetTypeIds be specified using a comma separator. If the function is executed successfully, it will return a RequestStatus object that contains the success or failure information.","operationId":"deleteAssetTypes","parameters":[{"name":"assetTypeIds","in":"query","description":"Specify a comma-separated list of unique asset type IDs (e.g., 1, 2, 3)","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/v1/metadatamanager/metadata":{"post":{"tags":["Environment"],"summary":"Get metadata","description":"The function returns metadata information as a JSONArray, which includes values like systemId, systemName, environmentId, environmentName, environmentType, and dataSourceType, with input values being SERVER, DATABASE, SCHEMA, and TABLENAME in json format. The sample JSON format is: <br>\n{<br>\n \"SERVER\":\"\",<br>\n \"DATABASE\":\"\",<br>\n \"SCHEMA\":\"\",<br>\n \"TABLENAME\":\"\"<br>\n }","operationId":"getMetaData","requestBody":{"content":{"application/json":{"schema":{"type":"string"}}},"required":true},"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/v1/metadatamanager/environments/{environment_id}/version":{"post":{"tags":["Environment"],"summary":"Version environment","description":"Creates a new environment version with copied metadata and a new ID, including state, properties, values, fields, and documents.","operationId":"versionEnvironment","parameters":[{"name":"environment_id","in":"path","description":"ID of the environment that needs to be versioned","required":true,"schema":{"type":"integer","format":"int32"}},{"name":"changeDescription","in":"query","description":"Provide the change description","required":true,"schema":{"type":"string"}},{"name":"versionLabel","in":"query","description":"Provide the version label","required":false,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/v1/metadatamanager/environments/{environment_id}/scan":{"post":{"tags":["Environment"],"summary":"Scan tables into environment","description":"The method scans and saves environment metadata into a specified environmentId using the provided dbHelper object and dbOperation settings.<br>\nThe dbHelper object must contain certain mandatory properties:<br>\ndatabaseType: Defines the type of database to be scanned and saved. The possible values are referenced in com.icc.util.DBProperties.DatabaseType.<br>\nscanCriteria: Defines the selection criteria for objects (TABLES/VIEWS/SYNONYMS/COMPONENTS) to be saved into the specified environment. Possible values are INCLUDE_SELECTION, EXCLUDE_SELECTION, or ALL. Referenced in com.ads.mm.db.util.DBHelper.ScanCriteria.<br>\nfilePath: Mandatory when the databaseType is file-based.<br>\nfilePathType: Supported values are ABSOLUTE or RELATIVE.<br>\nuseReferenceId: Used for ERWIN and CWM file-based databases, accepts a boolean value.<br>\nmodelType and readLogicalColumns: Used for ERWIN or ERWIN9 file-based databases to define the display order of tables and whether to skip logical columns. modelType can be PHYSICAL or LOGICAL, and readLogicalColumns accepts a boolean value.<br>\nThe dbOperation object specifies operation modes for saving the environment:<br>\nFRESH_UPLOAD: Used when the previously loaded environment tables are to be deleted and new tables will be inserted in to the environment.<br>\nUPDATE_APPEND: Used when a previously loaded environment is modified, and new tables are appended.<br>\nAPPEND: Used when environment metadata is saved for the first time (add new option).<br>\nUPDATE_APPEND_INVALIDATE: Used when previously loaded metadata is modified, new tables are appended, and some scanned tables need to be invalidated in the environment. These modes are referenced in com.icc.util.DBProperties.Operation.<br>\nIf the function is executed successfully, it will return a RequestStatus object that contains the success or failure information.","operationId":"scanIntoEnvironment","parameters":[{"name":"environment_id","in":"path","description":"provide the ID of the environment that needs to be scanned for metadata.","required":true,"schema":{"type":"integer","format":"int32"}},{"name":"dbOperation","in":"query","required":false,"schema":{"type":"string","enum":["FRESH_UPLOAD","APPEND","UPDATE_APPEND","UPDATE_APPEND_INVALIDATE"]}}],"requestBody":{"content":{"application/json":{"schema":{"$ref":"#/components/schemas/DBHelper"}},"application/xml":{"schema":{"$ref":"#/components/schemas/DBHelper"}}},"required":true},"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/miscellaneous/upload-file":{"post":{"tags":["File Resource"],"summary":"Uploads the file","description":"This function is used to upload the specified file to the server and return the file's relative path. The path will be accessible via the user object of the returned requestStatus object.","operationId":"uploadFile","requestBody":{"content":{"multipart/form-data":{"schema":{"required":["file"],"type":"object","properties":{"file":{"type":"string","format":"binary"}}}}}},"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/miscellaneous/tags/publish":{"post":{"tags":["Tag"],"summary":"Publish tags","description":"To publish or unpublish tags It is mandatory to specify the list of tag IDs and their state. If the state value is set to true, the tags will be published. If the state value is set to false, the tags will be unpublished.","operationId":"publishTags","parameters":[{"name":"tagIds","in":"query","description":"Specify a comma-separated list of unique tag IDs (e.g., 1, 2, 3)","required":true,"schema":{"type":"string"}},{"name":"state","in":"query","description":"Select the state to publish or unpublish","required":true,"schema":{"type":"boolean"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/miscellaneous/tags/dissociate":{"post":{"tags":["Tag"],"summary":"Dissociate tags by tag names.","description":"A list of tags are dissociated from the objects for the specified nodeType and list of object IDs. The specification of nodeType, list of object IDs, and tag names are mandatory.","operationId":"dissociateTags","parameters":[{"name":"nodeType","in":"query","description":"Select the nodeType to dissociate the tags","required":true,"schema":{"type":"string","enum":["SM_SYSTEM","SM_ENVIRONMENT","SM_TABLE","SM_COLUMN","MM_PROJECT","MM_SUBJECT","MM_MAPPING","BGM_TERM","BGM_RULE","BGM_POLICY","BGM_CUSTOM"]}},{"name":"objectIds","in":"query","description":"Specify a comma-separated list of unique object IDs (e.g., 1, 2, 3)","required":true,"schema":{"type":"string"}},{"name":"tagNames","in":"query","description":"Provide the list of tag names to dissociate","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/miscellaneous/tags/clear":{"post":{"tags":["Tag"],"summary":"Clear the list of tags.","description":"Clears the tags for the specified nodeType and node IDs. Specifying the nodeType and nodeIds are mandatory to clear the tags, i.e., they remove all the tags associated with the objects.","operationId":"clearTags","parameters":[{"name":"nodeType","in":"query","description":"Select the node type to clear the tags","required":true,"schema":{"type":"string","enum":["SM_SYSTEM","SM_ENVIRONMENT","SM_TABLE","SM_COLUMN","MM_PROJECT","MM_SUBJECT","MM_MAPPING","BGM_TERM","BGM_RULE","BGM_POLICY","BGM_CUSTOM"]}},{"name":"objectIds","in":"query","description":"Specify a comma-separated list of unique object IDs (e.g., 1, 2, 3)","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/miscellaneous/tags/associate":{"post":{"tags":["Tag"],"summary":"Associate tags by tag names.","description":"A list of tags are associated to the objects for the specified nodeType and list of object IDs. The specification of nodeType, list of object IDs, and tag names are mandatory.","operationId":"associateTags","parameters":[{"name":"nodeType","in":"query","description":"Select the nodeType to associate the tags","required":true,"schema":{"type":"string","enum":["SM_SYSTEM","SM_ENVIRONMENT","SM_TABLE","SM_COLUMN","MM_PROJECT","MM_SUBJECT","MM_MAPPING","BGM_TERM","BGM_RULE","BGM_POLICY","BGM_CUSTOM"]}},{"name":"objectIds","in":"query","description":"Specify a comma-separated list of unique object IDs (e.g., 1, 2, 3)","required":true,"schema":{"type":"string"}},{"name":"tagNames","in":"query","description":"Provide the list of tag names to associate","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/mappingmanager/projects/{project_id}/baseline":{"post":{"tags":["Project"],"summary":"Appends the baseline to the project","description":"The baseline is added to the project with the specified projectId.","operationId":"baselineProject","parameters":[{"name":"project_id","in":"path","description":"ID of the project to append the baseline","required":true,"schema":{"type":"integer","format":"int32"}},{"name":"versionLabel","in":"query","description":"Provide the version label","required":false,"schema":{"type":"string"}},{"name":"changeDescription","in":"query","description":"Provide the change description","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/mappingmanager/mappings/{mapping_id}/version":{"post":{"tags":["Mapping"],"summary":"Version mapping","description":"Appends a new version to the mappings, specifying the changed description is mandatory along with the other details of mapping object.","operationId":"versionMapping","parameters":[{"name":"mapping_id","in":"path","description":"ID of the mapping that needs to be versioned","required":true,"schema":{"type":"integer","format":"int32"}},{"name":"versionLabel","in":"query","description":"Provide the version label","required":false,"schema":{"type":"string"}},{"name":"changeDescription","in":"query","description":"Provide the change description","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/mappingmanager/mappings/{mapping_id}/unpublish":{"post":{"tags":["Mapping"],"summary":"Unpublish mapping","description":"If you want to unpublish a mapping, you need to specify the mappingId. Once it's unpublished, it becomes a normal map in the project tree.","operationId":"unPublishMap","parameters":[{"name":"mapping_id","in":"path","description":"ID of the mapping that needs to be unpublished","required":true,"schema":{"type":"integer","format":"int32"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/mappingmanager/mappings/{mapping_id}/publish":{"post":{"tags":["Mapping"],"summary":"Publish mapping","description":"A mapping will be published for the specified mapping ID, effective date, changeDescription and publishNotes which are mandatory.","operationId":"publishMapping","parameters":[{"name":"mapping_id","in":"path","description":"ID of the mapping that needs to be published","required":true,"schema":{"type":"integer","format":"int32"}},{"name":"effectiveDate","in":"query","description":"Expected date format is YYYY-MM-DD HH:mm:ss","required":true,"schema":{"type":"string"}},{"name":"changeDescription","in":"query","description":"Provide the change description","required":true,"schema":{"type":"string"}},{"name":"publishNotes","in":"query","description":"Provide the publish notes","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/mappingmanager/mappings/sync/metadata":{"post":{"tags":["Mapping"],"summary":"To sync source/target metdata","description":"This function is used to sync the source and target metadata information in mapping specifications for the specifed mappingIds. Specifying the list of mappingIds in the request body is mandatory.","operationId":"syncMetadata","requestBody":{"content":{"application/json":{"schema":{"type":"array","items":{"type":"integer","format":"int32"}}},"application/xml":{"schema":{"type":"array","items":{"type":"integer","format":"int32"}}}},"required":true},"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/mappingmanager/mappings/publish":{"post":{"tags":["Mapping"],"summary":"Publish mappings list","description":"Mappings will be published for the specified mapping ID, effective date, changeDescription and publishNotes which are mandatory.","operationId":"publishMappings","parameters":[{"name":"mappingIds","in":"query","description":"Specify a comma-separated list of unique mapping IDs (e.g., 1, 2, 3)","required":true,"schema":{"type":"string"}},{"name":"effectiveDate","in":"query","description":"Expected date format is YYYY-MM-DD HH:mm:ss","required":true,"schema":{"type":"string"}},{"name":"changeDescription","in":"query","description":"Provide the change description","required":true,"schema":{"type":"string"}},{"name":"publishNotes","in":"query","description":"Provide the publish notes","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/v1/metadatamanager/tables/{table_id}":{"get":{"tags":["Table"],"summary":"Get table by ID and fill options","description":"The method's purpose is to retrieve detailed information about a specific table identified by its tableId. <br> To use this method, two parameters are mandatory: tableId and fillOptions. <br>The returned SMTable object contains various details about the table, including tableName,\ntable definition, environment name in which the table is present, etc. <br>The fillOptions parameter is used to specify what additional data should be included in the SMTable object. <br>The following values can be used for fillOptions:<br>\nAPIConstants.SMFillOptions#TABLE_INDEXES (Value: 1) - Include table indexes in the returned object. <br>APIConstants.SMFillOptions#TABLE_EXTENDED_PROPERTIES (Value: 4) - Include table extended properties in the returned table object. <br>APIConstants.SMFillOptionsTABLE_COLUMNS (Value: 2) - Include columns in the returned table object.<br>\nFor example, if you want to retrieve the SMTable object with both table indexes and its columns, you would pass a value of 3 (1 for TABLE_INDEXES + 2 for TABLE_COLUMNS) as the fillOptions. <br>The default value for fillOptions is 0 (zero), indicating that no additional data beyond the basic details is included.","operationId":"getTable","parameters":[{"name":"table_id","in":"path","description":"ID of the table that needs to be fetched","required":true,"schema":{"type":"integer","format":"int32"}},{"name":"fillOptions","in":"query","description":"Possible values: 1,2,4","required":false,"schema":{"type":"integer","format":"int32","default":0}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/v1/metadatamanager/tables/id":{"get":{"tags":["Table"],"summary":"Get table ID","description":"The function returns the table ID for a specific systemName, environmentName and tableName combination, which are mandatory.","operationId":"getTableId","parameters":[{"name":"systemName","in":"query","description":"Provide the name of the system in which the table is present","required":true,"schema":{"type":"string"}},{"name":"environmentName","in":"query","description":"Provide the name of the environment in which the table is present","required":true,"schema":{"type":"string"}},{"name":"tableName","in":"query","description":"Provide the name of the table to retrieve the ID","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/v1/metadatamanager/systems/{system_id}":{"get":{"tags":["System"],"summary":"Get system by ID","description":"Retrieve a system object using its ID and receive a response with its name and additional information..","operationId":"getSystem","parameters":[{"name":"system_id","in":"path","description":"ID of the system that needs to be fetched","required":true,"schema":{"type":"integer","format":"int32"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/v1/metadatamanager/systems/id":{"get":{"tags":["System"],"summary":"Get system ID","description":"The function returns the system ID for the given system name.","operationId":"getSystemId","parameters":[{"name":"systemName","in":"query","description":"Provide the name of the system to retrieve the ID","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/v1/metadatamanager/environments/{environment_id}":{"get":{"tags":["Environment"],"summary":"Get environment by ID and fill options","description":"The method returns detailed information about a specific SMEnvironment identified by its environmentId. The environmentId parameter is mandatory, meaning it must be provided when calling the method.\nThe method returns various details related to the environment, including : environmentId, environmentName, environmentType, systemId, systemName and other database-related details such as userName, password, and dbDriver information.\nThe fill options parameter is used to specify what additional data should be returned within the SMEnvironment object.\nThe value for fill options is expected to be one of the constants defined in the APIConstants.SMFillOptions class. The following values can be used to define fill options:<br>APIConstants.SMFillOptions#ENVIRONMENT_TABLES_COLUMNS(Value 256): Includes tables and columns in the returned environment object.<br>\nIf you want to retrieve the environment object with both tables and columns, including their extended properties, you would pass a value of 276 (256 for ENVIRONMENT_TABLES_COLUMNS + 4 TABLE_EXTENDED_PROPERTIES + 16 for COLUMN_EXTENDED_PROPERTIES) as the fill options.\nDepending on the value passed as fillOptions, related data is included in the SMEnvironment object.\nThe default value for fillOptions is 0 (zero), indicating that no additional data beyond the basic details is included.","operationId":"getEnvironment","parameters":[{"name":"environment_id","in":"path","description":"ID of the environment that needs to be fetched","required":true,"schema":{"type":"integer","format":"int32"}},{"name":"fillOptions","in":"query","description":"Possible values: 256","required":false,"schema":{"type":"integer","format":"int32","default":0}},{"name":"useReferenceId","in":"query","required":false,"schema":{"type":"boolean"}},{"name":"page","in":"query","description":"By default, the first page is listed. To navigate through pages, use this parameter. If the value of the page is 0 or -1, it will retrieve the records on the first page only.","required":false,"schema":{"type":"integer","format":"int32","default":1}},{"name":"per_page","in":"query","description":"This parameter sets the number of records to be returned in a response. If the value of the per_page is 0 or -1, records will be returned based on the threshold value provided in the Application.properties file.","required":false,"schema":{"type":"integer","format":"int32","default":25}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/v1/metadatamanager/environments/system_id":{"get":{"tags":["Environment"],"summary":"Get environments by system ID","description":"The method returns a list of SMEnvironment objects based on specified system ID. The systemId parameter is mandatory, meaning it must be provided when calling the method. <br> Note: Pagination is applied, and by default, 25 records are displayed per page.","operationId":"getEnvironmentsBySystemId","parameters":[{"name":"systemId","in":"query","description":"Provide the system ID.","required":true,"schema":{"type":"integer","format":"int32"}},{"name":"page","in":"query","description":"By default, the first page is listed. To navigate through pages, use this parameter. If the value of the page is 0 or -1, it will retrieve the records on the first page only.","required":false,"schema":{"type":"integer","format":"int32","default":1}},{"name":"per_page","in":"query","description":"This parameter sets the number of records to be returned in a response. If the value of the per_page is 0 or -1, records will be returned based on the threshold value provided in the Application.properties file.","required":false,"schema":{"type":"integer","format":"int32","default":25}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/v1/metadatamanager/environments/id":{"get":{"tags":["Environment"],"summary":"Get environment ID","description":"The function returns the environment ID for a specific system and environment name combination , which are mandatory.","operationId":"getEnvironmentId","parameters":[{"name":"systemName","in":"query","description":"Provide the name of the system in which the environment is present","required":true,"schema":{"type":"string"}},{"name":"environmentName","in":"query","description":"Provide the name of the environment to retrieve the ID","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/v1/metadatamanager/columns/{column_id}":{"get":{"tags":["Column"],"summary":"Retrieve a column by ID and fill options","description":"The method's purpose is to retrieve detailed information about a specific column identified by its columnId.\nTo use this method, two parameters are mandatory: columnId and fill options. The returned SMColumn object contains various details about the column, including:\ncolumnName, tableName: The name of the table in which the column is located.<br> The fill options parameter is used to specify what additional data should be included in the SMColumn object. <br>The following values can be used for fill options:<br>\nAPIConstants.SMFillOptions#COLUMN_INDEXES (Value: 8) - Include column indexes in the returned column object.<br>APIConstants.SMFillOptions#COLUMN_EXTENDED_PROPERTIES (Value: 16) - Include column extended properties in the returned column object.<br>APIConstants.SMFillOptions#COLUMN_VALID_VALUES (Value: 32) - Include valid values for the column.<br>APIConstants.SMFillOptions#VALID_VALUES_EXTENDED_PROPERTIES (Value: 64) - Include extended properties of valid values. <br>Depending on the combination of values passed in the fillOptions parameter, the returned SMColumn object will contain different sets of related data.\nFor example, if you want to retrieve the SMColumn object with both column indexes and column extended properties, you would pass a value of 24 (8 for COLUMN_INDEXES + 16 for COLUMN_EXTENDED_PROPERTIES) as the fillOptions.<br>The default value for fillOptions is 0 (zero), indicating that no additional data beyond the basic details is included.","operationId":"getColumn","parameters":[{"name":"column_id","in":"path","description":"ID of the column to be searched","required":true,"schema":{"type":"integer","format":"int32"}},{"name":"fillOptions","in":"query","description":"Possible values: 8,16,32,64","required":false,"schema":{"type":"integer","format":"int32","default":0}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/v1/metadatamanager/columns/id":{"get":{"tags":["Column"],"summary":"Get column ID","description":"The function returns the column ID for the given systemName, environmentName, tableName, and columnName which are mandatory.","operationId":"getColumnId","parameters":[{"name":"systemName","in":"query","description":"Provide the name of the system in which the column is present","required":true,"schema":{"type":"string"}},{"name":"environmentName","in":"query","description":"Provide the name of the environment in which the column is present","required":true,"schema":{"type":"string"}},{"name":"tableName","in":"query","description":"Provide the name of the table in which the column is present","required":true,"schema":{"type":"string"}},{"name":"columnName","in":"query","description":"Provide the name of the column to retrieve the ID","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/miscellaneous/tags/associations":{"get":{"tags":["Tag"],"summary":"Get tag associations for the specified tag name.","description":"This function returns the list of associations of the tag object for the specified tag name. Specifying the fillInfo is required to return the source and target object details.","operationId":"getTagAssociations","parameters":[{"name":"tagName","in":"query","description":"Provide the tag name to get associations","required":true,"schema":{"type":"string"}},{"name":"fillInfo","in":"query","description":"Whether to include source and target object details or not","required":false,"schema":{"type":"boolean"}},{"name":"page","in":"query","description":"By default, the first page is listed. To navigate through pages, use this parameter. If the value of the page is 0 or -1, it will retrieve the records on the first page only.","required":false,"schema":{"type":"integer","format":"int32","default":1}},{"name":"per_page","in":"query","description":"This parameter sets the number of records to be returned in a response. If the value of the per_page is 0 or -1, records will be returned based on the threshold value provided in the Application.properties file.","required":false,"schema":{"type":"integer","format":"int32","default":25}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/miscellaneous/tag/id":{"get":{"tags":["Tag"],"summary":"Get tag ID.","description":"The function returns the tag ID for the given tag name.","operationId":"getTagId","parameters":[{"name":"tagName","in":"query","description":"Provide the name of the tag to retrive ID","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/miscellaneous/object/tags":{"get":{"tags":["Tag"],"summary":"Get the list of tags which are associated to the specified object.","description":"To obtain a list of all associated tags of an object for the specified objectId and nodeType. The specification of nodeType and nodeId are mandatory. <br> Note: Pagination is applied, and by default, 25 records are displayed per page.","operationId":"getAssociatedTags","parameters":[{"name":"nodeType","in":"query","description":"Select the nodeType to get the associated tags with the object","required":true,"schema":{"type":"string","enum":["SM_SYSTEM","SM_ENVIRONMENT","SM_TABLE","SM_COLUMN","MM_PROJECT","MM_SUBJECT","MM_MAPPING","BGM_TERM","BGM_RULE","BGM_POLICY","BGM_CUSTOM"]}},{"name":"objectId","in":"query","description":"ID of the object i.e., nodeId based on the nodeType.","required":true,"schema":{"type":"integer","format":"int32"}},{"name":"page","in":"query","description":"By default, the first page is listed. To navigate through pages, use this parameter. If the value of the page is 0 or -1, it will retrieve the records on the first page only.","required":false,"schema":{"type":"integer","format":"int32","default":1}},{"name":"per_page","in":"query","description":"This parameter sets the number of records to be returned in a response. If the value of the per_page is 0 or -1, records will be returned based on the threshold value provided in the Application.properties file.","required":false,"schema":{"type":"integer","format":"int32","default":25}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/miscellaneous/download-file":{"get":{"tags":["File Resource"],"summary":"Downloads the file","description":"Downloads the file from the given file location on the server, specifying the file location is mandatory, and the input file path should be relative path only.","operationId":"downloadFile","parameters":[{"name":"fileLocation","in":"query","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/miscellaneous/associations/objectIds":{"get":{"tags":["Association"],"summary":"Get associations list by objectIds.","description":"To retrieve a list of association objects, you must provide a list of objectIds and objectType. The parameter \"fillInfo\" can be set to either true or false. If it is set to true, the association object will be returned with both the source and target objects filled in with details. If it is set to false, only the association details will be returned. Note: Pagination is applied, and by default, 25 records are displayed per page.","operationId":"getAssociationsByObjectType","parameters":[{"name":"nodeType","in":"query","description":"Select the nodeType to get associations","required":true,"schema":{"type":"string","enum":["SM_SYSTEM","SM_ENVIRONMENT","SM_TABLE","SM_COLUMN","BGM_TERM","BGM_RULE","BGM_POLICY","BGM_CUSTOM"]}},{"name":"objectIds","in":"query","description":"Specify a comma-separated list of unique object IDs (e.g., 1, 2, 3)","required":true,"schema":{"type":"string"}},{"name":"fillInfo","in":"query","description":"Whether to include source and target object details or not","required":false,"schema":{"type":"boolean"}},{"name":"page","in":"query","description":"By default, the first page is listed. To navigate through pages, use this parameter. If the value of the page is 0 or -1, it will retrieve the records on the first page only.","required":false,"schema":{"type":"integer","format":"int32","default":1}},{"name":"per_page","in":"query","description":"This parameter sets the number of records to be returned in a response. If the value of the per_page is 0 or -1, records will be returned based on the threshold value provided in the Application.properties file.","required":false,"schema":{"type":"integer","format":"int32","default":25}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/mappingmanager/subjects/{subject_id}":{"get":{"tags":["Subject"],"summary":"Get subject by ID.","description":"Retrieve the subject object associated with the provided subjectId.","operationId":"getSubject","parameters":[{"name":"subject_id","in":"path","description":"ID of the subject that neeeds to be fetched.","required":true,"schema":{"type":"integer","format":"int32"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/mappingmanager/subjects/id":{"get":{"tags":["Subject"],"summary":"Get subject ID","description":"The function returns the subjectId of a specific subjectPath within a specific project.","operationId":"getSubjectId","parameters":[{"name":"projectName","in":"query","description":"Provide the name of the project in which the subject is present","required":true,"schema":{"type":"string"}},{"name":"subjectPath","in":"query","description":"Sample for subjectPath ==> (s1/s2)- to get s2 ID and (s1)- to get s1 ID","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/mappingmanager/projects/{project_id}":{"get":{"tags":["Project"],"summary":"Get project by ID","description":"Retrieve the project object associated with the provided projectId.","operationId":"getProject","parameters":[{"name":"project_id","in":"path","description":"ID of the project that needs to be fetched","required":true,"schema":{"type":"integer","format":"int32"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/mappingmanager/projects/id":{"get":{"tags":["Project"],"summary":"Get project ID","description":"The function returns the project ID for the specified projectName.","operationId":"getProjectId","parameters":[{"name":"projectName","in":"query","description":"Provide the name of the project to retrieve the ID","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/mappingmanager/mappings/{mapping_id}":{"get":{"tags":["Mapping"],"summary":"Get mapping by ID and fill options","description":"To retrieve mapping object for the specified mappingId and fill options value. The fill options parameter is used to specify what additional data should be included in the mapping object.<br> The following values can be used for fill options:<br>\nAPIConstants.MMFillOptions #MAPPING_SPECIFICATIONS (Value 1): include mapping specifications in the returned object.<br> APIConstants.MMFillOptions#MAPPING_DOCUMENTS(Value 2): include mapping documents in the returned object.<br>\nDepending on the combination of values passed in the fill options parameter, the returned mapping object will contain different sets of related data. For example, if you want to retrieve the mapping object with both mapping specifications and mapping documents, you would pass a value of 3 (1 for MAPPING_SPECIFICATIONS + 2 for MAPPING_DOCUMENTS) as the fill options. The default value for fill options is 0 (zero), indicating that no additional data beyond the basic details is included.<br>\nNote: Pagination is applied, and by default, 25 records are displayed per page.","operationId":"getMapping","parameters":[{"name":"mapping_id","in":"path","description":"ID of the mapping that needs to be fetched","required":true,"schema":{"type":"integer","format":"int32"}},{"name":"fillOptions","in":"query","description":"Possible values: 1,2","required":false,"schema":{"type":"integer","format":"int32","default":0}},{"name":"page","in":"query","description":"By default, the first page is listed. To navigate through pages, use this parameter. If the value of the page is 0 or -1, it will retrieve the records on the first page only.","required":false,"schema":{"type":"integer","format":"int32","default":1}},{"name":"per_page","in":"query","description":"This parameter sets the number of records to be returned in a response. If the value of the per_page is 0 or -1, records will be returned based on the threshold value provided in the Application.properties file.","required":false,"schema":{"type":"integer","format":"int32","default":25}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/mappingmanager/mappings/specifications/{mapping_id}":{"get":{"tags":["Mapping"],"summary":"Get mapping specifications list.","description":"To obtain a list of list of mapping specifications for the specified mappingId. Note: Pagination is applied, and by default, 25 records are displayed per page.","operationId":"getMappingSpecifications_1","parameters":[{"name":"mapping_id","in":"path","description":"Specify the mapping ID to obtain specifications","required":true,"schema":{"type":"integer","format":"int32"}},{"name":"page","in":"query","description":"By default, the first page is listed. To navigate through pages, use this parameter. If the value of the page is 0 or -1, it will retrieve the records on the first page only.","required":false,"schema":{"type":"integer","format":"int32","default":1}},{"name":"per_page","in":"query","description":"This parameter sets the number of records to be returned in a response. If the value of the per_page is 0 or -1, records will be returned based on the threshold value provided in the Application.properties file.","required":false,"schema":{"type":"integer","format":"int32","default":25}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/mappingmanager/mappings/id":{"get":{"tags":["Mapping"],"summary":"Get mapping ID","description":"The function returns the mappingId of a specific projectName, subjectPath and mappingName. Specifying the projectName and mappingName are mandatory. If the Map is present in the subject specifying the subjectPath is mandatory.","operationId":"getMappingId","parameters":[{"name":"projectName","in":"query","description":"Provide the name of the project in which the mapping is present","required":true,"schema":{"type":"string"}},{"name":"subjectPath","in":"query","description":"Sample for subjectPath ==> (s1/s2)- to get s2 ID and (s1)- to get s1 ID","required":false,"schema":{"type":"string"}},{"name":"mappingName","in":"query","description":"Provide the name of the mapping to retrieve the ID","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/datalineage/table":{"get":{"tags":["Lineage"],"summary":"Get table lineage","description":"To obtain the lineage object response for the specified system name, environment name, and table name. The returned lineage object contains details of source and target objects.","operationId":"getTableLineage","parameters":[{"name":"lineageType","in":"query","required":true,"schema":{"type":"string","enum":["FORWARD","REVERSE","DUAL"]}},{"name":"systemName","in":"query","required":true,"schema":{"type":"string"}},{"name":"environmentName","in":"query","required":true,"schema":{"type":"string"}},{"name":"tableName","in":"query","required":true,"schema":{"type":"string"}},{"name":"projectIds","in":"query","required":false,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/datalineage/system":{"get":{"tags":["Lineage"],"summary":"Get system lineage","description":"To obtain the lineage object response for the specified system name. The returned lineage object contains details of source and target objects.","operationId":"getSystemLineage","parameters":[{"name":"lineageType","in":"query","required":true,"schema":{"type":"string","enum":["FORWARD","REVERSE","DUAL"]}},{"name":"systemName","in":"query","required":true,"schema":{"type":"string"}},{"name":"projectIds","in":"query","required":false,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/datalineage/environment":{"get":{"tags":["Lineage"],"summary":"Get environment lineage","description":"To obtain the lineage object response for the specified system and environment name. The returned lineage object contains details of source and target objects.","operationId":"getEnvironmentLineage","parameters":[{"name":"lineageType","in":"query","required":true,"schema":{"type":"string","enum":["FORWARD","REVERSE","DUAL"]}},{"name":"systemName","in":"query","required":true,"schema":{"type":"string"}},{"name":"environmentName","in":"query","required":true,"schema":{"type":"string"}},{"name":"projectIds","in":"query","required":false,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/datalineage/column":{"get":{"tags":["Lineage"],"summary":"Get column lineage","description":"To obtain the lineage object response for the specified system, environment, table and column name.","operationId":"getColumnLineage","parameters":[{"name":"lineageType","in":"query","required":true,"schema":{"type":"string","enum":["FORWARD","REVERSE","DUAL"]}},{"name":"systemName","in":"query","required":true,"schema":{"type":"string"}},{"name":"environmentName","in":"query","required":true,"schema":{"type":"string"}},{"name":"tableName","in":"query","required":true,"schema":{"type":"string"}},{"name":"columnName","in":"query","required":true,"schema":{"type":"string"}},{"name":"projectIds","in":"query","required":false,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/businessglossarymanager/catalogs/{catalog_id}":{"get":{"tags":["Catalog"],"summary":"Get catalog by ID","description":"The function returns all the details, like catalogName, parentCatalogId, catalogTypeId and auditHistory details of the catalog objects for the given catalog ID.","operationId":"getCatalog","parameters":[{"name":"catalog_id","in":"path","description":"ID of the catalog that needs to be fetched","required":true,"schema":{"type":"integer","format":"int32"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/businessglossarymanager/catalogs/{catalog_id}/path":{"get":{"tags":["Catalog"],"summary":"Get catalog path","description":"To get the catalog path, provide the nodeType and catalogId. Options for nodeType are BGM_TERM, BGM_RULE, BGM_POLICY, and for custom types it will be the name of asset type given in settings. Based on the nodeType the catalogId will be either business term, policy, rule, or custom object's catalog ID. The function will return the catalogPath.","operationId":"getCatalogPath","parameters":[{"name":"nodeType","in":"query","description":"Supported node types are BGM_TERM, BGM_RULE, BGM_POLICY, and for custom types it will be the name of asset type given in settings.","required":true,"schema":{"type":"string"}},{"name":"catalog_id","in":"path","description":"provide the ID of the catalog in order to retrieve its path.","required":true,"schema":{"type":"integer","format":"int32"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/businessglossarymanager/catalogs/id":{"get":{"tags":["Catalog"],"summary":"Get catalog ID","description":"To obtain the catalog ID, you must specify the assetTypeName and catalogPath. Both of these fields are required. AssetTypeName can be Business Terms, Business Policies, or Business Rules. For custom objects, use the name from settings. CatalogPath is catalogPath+catalogName(ex: Catalog1/Catalog2/Catalog3)","operationId":"getCatalogId","parameters":[{"name":"assetTypeName","in":"query","description":"Provide the name of the asset type to retrieve the ID","required":true,"schema":{"type":"string"}},{"name":"catalogPath","in":"query","description":"A sample catalog path for catalog2 is (catalog1/catalog2)","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/businessglossarymanager/catalogs/assetTypeId":{"get":{"tags":["Catalog"],"summary":"Get catalogs by assetTypeId.","description":" The function returns list of catalogs filled in with the details, like catalogName, parentCatalogId, catalogTypeId and auditHistory details of the catalog objects for the given assetTypeId and fill options. The fill options parameter is an optional parameter that helps to specify additional data needed for each catalog object. We can define this data by using constants defined in the APIConstants.BGMFillOptions class.<br> The following values can be used to define fill options:<br> APIConstants.BGMFillOptions#CATALOG_EXTENDED_PROPERTIES (Value 1): This includes extended properties in the returned catalog objects.<br> The default value for fill options is 0, which means that no additional data beyond the basic details is returned. <br> Note: Pagination is applied, and by default, 25 records are displayed per page.","operationId":"getCatalogsByAssetTypeId","parameters":[{"name":"assetTypeId","in":"query","description":"Specify assetTypeId","required":true,"schema":{"type":"integer","format":"int32"}},{"name":"fillOptions","in":"query","description":"Possible values: 0 or 1","required":false,"schema":{"type":"integer","format":"int32","default":0}},{"name":"page","in":"query","description":"By default, the first page is listed. To navigate through pages, use this parameter. If the value of the page is 0 or -1, it will retrieve the records on the first page only.","required":false,"schema":{"type":"integer","format":"int32","default":1}},{"name":"per_page","in":"query","description":"This parameter sets the number of records to be returned in a response. If the value of the per_page is 0 or -1, records will be returned based on the threshold value provided in the Application.properties file.","required":false,"schema":{"type":"integer","format":"int32","default":25}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/businessglossarymanager/assets/{asset_id}":{"get":{"tags":["Business Asset"],"summary":"Get business asset by ID and node type","description":"To retrieve a business object, select the nodeType and provide businessAssetId. Node type options can be either BGM_TERM, BGM_RULE, BGM_POLICY, or BGM_CUSTOM. Depending on the node type, businessAssetId will be either a term, policy, rule, or custom object ID.","operationId":"getBusinessAsset","parameters":[{"name":"nodeType","in":"query","description":"Select the node Type.","required":true,"schema":{"type":"string","enum":["BGM_TERM","BGM_RULE","BGM_POLICY","BGM_CUSTOM"]}},{"name":"asset_id","in":"path","description":"ID of the business asset that needs to be fetched","required":true,"schema":{"type":"integer","format":"int32"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/businessglossarymanager/assets/types/{type_id}":{"get":{"tags":["Asset Type"],"summary":"Get asset type by ID","description":"The function returns all the details of the asset type like ID, name, description, title, objectTypeId and catalogTypeId for the given assetTypeId.","operationId":"getAssetType","parameters":[{"name":"type_id","in":"path","description":"ID of the asset type that needs to be fetched","required":true,"schema":{"type":"integer","format":"int32"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/businessglossarymanager/assets/types/id":{"get":{"tags":["Asset Type"],"summary":"Get asset type ID","description":"To retrieve the asset type ID for a specific asset type, it is required to provide the assetTypeName. The supported assetTypeNames are Business Terms, Business Policies, and Business Rules. For custom objects, the asset type is identified by the name provided during creation in the settings.","operationId":"getAssetTypeId","parameters":[{"name":"assetTypeName","in":"query","description":"Provide the name of the asset type to retrieve the ID","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/businessglossarymanager/assets/id":{"get":{"tags":["Business Asset"],"summary":"Get business asset ID","description":"To obtain the ID of a specific businessAsset (Business object), it is mandatory to provide the assetTypeName, catalogPath, and businessAssetName. This will return the desired result.<br> Asset type name can be either Business Terms, Business Policies, or Business Rules. For custom objects, use the name from settings. CatalogPath is catalogPath+catalogName(ex: Catalog1/Catalog2/Catalog3).","operationId":"getBusinessAssetId","parameters":[{"name":"assetTypeName","in":"query","description":"Supported names are Business Terms, Business Policies, Business Rules and for custom objects it will be the name given in settings","required":true,"schema":{"type":"string"}},{"name":"catalogPath","in":"query","description":"A sample catalog path for catalog2 is (catalog1/catalog2)","required":true,"schema":{"type":"string"}},{"name":"businessAssetName","in":"query","description":"Provide the name of the business asset to retrieve the ID","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/businessglossarymanager/assets/catalogId":{"get":{"tags":["Business Asset"],"summary":"Get business assets list by catalogId.","description":"The function returns a list of business assets for specified catalogId and selected node type. NodeType options can be either BGM_TERM, BGM_RULE, BGM_POLICY, or BGM_CUSTOM. Depending on the node type, catalogId will be either a business term, policy, rule, or custom object's catalogId. <br>Note: Pagination is applied, and by default, 25 records are displayed per page.","operationId":"getBusinessAssetsByCatalogId","parameters":[{"name":"nodeType","in":"query","description":"Select the node Type.","required":true,"schema":{"type":"string","enum":["BGM_TERM","BGM_RULE","BGM_POLICY","BGM_CUSTOM"]}},{"name":"catalogId","in":"query","description":"Specify catalogId","required":true,"schema":{"type":"integer","format":"int32"}},{"name":"page","in":"query","description":"By default, the first page is listed. To navigate through pages, use this parameter. If the value of the page is 0 or -1, it will retrieve the records on the first page only.","required":false,"schema":{"type":"integer","format":"int32","default":1}},{"name":"per_page","in":"query","description":"This parameter sets the number of records to be returned in a response. If the value of the per_page is 0 or -1, records will be returned based on the threshold value provided in the Application.properties file.","required":false,"schema":{"type":"integer","format":"int32","default":25}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}},"/api/miscellaneous/associations/ids":{"delete":{"tags":["Association"],"summary":"Delete associations.","description":"Deletes the associations with the specified list of associationIds. Specifying the association IDs list is mandatory.","operationId":"deleteAssociations_1","parameters":[{"name":"associationIds","in":"query","description":"Specify a comma-separated list of unique association IDs (e.g., 1, 2, 3)","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"OK","content":{"application/json":{},"application/xml":{}}}},"security":[{"ApiKeyAuth":[]}]}}},"components":{"schemas":{"SDIClassification":{"type":"object","properties":{"objectTypeId":{"type":"integer","format":"int32"},"objectId":{"type":"integer","format":"int32"},"id":{"type":"integer","format":"int32"},"name":{"type":"string"},"description":{"type":"string"}}},"SMTable":{"type":"object","properties":{"endPointType":{"type":"string","enum":["SOURCE","TARGET","BOTH","NONE"]},"nodeId":{"type":"string"},"nodeType":{"type":"string","enum":["MM_PROJECT","MM_SUBJECT","MM_MAPPING","MM_MAPPING_ROW","SM_METADATA","SM_SYSTEM","SM_ENVIRONMENT","SM_TABLE","SM_COLUMN","CSM_CODESET_CATEGORY","CSM_CODESET","REQM_SPECIFICATION","BGM_TERM","BGM_RULE","BGM_POLICY","BGM_CUSTOM","ADS_KEY_VALUE","CSM_CODE_VALUE","TAG","RSM_ROLE","ANY","BUSINESS_ENTITY_TYPE","DI_INSTANCE","LANGUAGE_KEY","APP_PREFERENCE","LINEAGE","BGM_CUSTOM_TYPES"]},"environmentId":{"type":"integer","format":"int32"},"systemId":{"type":"integer","format":"int32"},"tableName":{"type":"string"},"systemEnvironmentName":{"type":"string"},"tableDefinition":{"type":"string"},"totalRowsCount":{"type":"integer","format":"int32"},"tableType":{"type":"string","enum":["TABLE","VIEW","SYNONYM","COMPONENT"]},"logicalTableName":{"type":"string"},"physicalTableName":{"type":"string"},"valid":{"type":"boolean"},"actualTableName":{"type":"string"},"tableReferenceId":{"type":"string"},"usedInGapAnalysis":{"type":"boolean"},"userDefined1":{"type":"string"},"userDefined2":{"type":"string"},"userDefined3":{"type":"string"},"userDefined4":{"type":"string"},"userDefined5":{"type":"string"},"userDefined6":{"type":"string"},"userDefined7":{"type":"string"},"userDefined8":{"type":"string"},"userDefined9":{"type":"string"},"userDefined10":{"type":"string"},"tableComments":{"type":"string"},"fileType":{"type":"string"},"fileLocation":{"type":"string"},"tableClass":{"type":"string"},"tableAlias":{"type":"string"},"expandedLogicalName":{"type":"string"},"elnExpanded":{"type":"boolean"},"associatedBusinessTerm":{"type":"string"},"associatedBusinessTermId":{"type":"integer","format":"int32"},"status":{"type":"string"},"workflowStatus":{"type":"string"},"tableId":{"type":"integer","format":"int32"},"rootTable":{"type":"boolean"},"dataStewardName":{"type":"string","deprecated":true},"referenceId":{"type":"string"},"schemaName":{"type":"string"},"declarationPath":{"type":"string"},"marked":{"type":"boolean"},"metadataSource":{"type":"string"},"dataProfileScoreId":{"type":"integer","format":"int32"},"systemName":{"type":"string"},"sdiFlag":{"type":"boolean"},"dqToolProfileId":{"type":"string","deprecated":true},"dataQualityScore":{"type":"number","format":"float"},"impactScore":{"type":"number","format":"float","deprecated":true},"businessEntityType":{"type":"string"},"dqToolUpdatedTime":{"type":"string"},"sdiClassificationId":{"type":"integer","format":"int32"},"sdiclassifications":{"type":"array","items":{"$ref":"#/components/schemas/SDIClassification"}},"sdiDescription":{"type":"string"},"sdiClassificationName":{"type":"string"},"stmid":{"type":"integer","format":"int32"},"objectTypeId":{"type":"integer","format":"int32"}},"xml":{"name":"table"}},"SMSystem":{"type":"object","properties":{"endPointType":{"type":"string","enum":["SOURCE","TARGET","BOTH","NONE"]},"nodeId":{"type":"string"},"nodeType":{"type":"string","enum":["MM_PROJECT","MM_SUBJECT","MM_MAPPING","MM_MAPPING_ROW","SM_METADATA","SM_SYSTEM","SM_ENVIRONMENT","SM_TABLE","SM_COLUMN","CSM_CODESET_CATEGORY","CSM_CODESET","REQM_SPECIFICATION","BGM_TERM","BGM_RULE","BGM_POLICY","BGM_CUSTOM","ADS_KEY_VALUE","CSM_CODE_VALUE","TAG","RSM_ROLE","ANY","BUSINESS_ENTITY_TYPE","DI_INSTANCE","LANGUAGE_KEY","APP_PREFERENCE","LINEAGE","BGM_CUSTOM_TYPES"]},"systemId":{"type":"integer","format":"int32"},"systemName":{"type":"string"},"systemPrimaryMoveType":{"type":"string"},"systemBusinessPurposeShort":{"type":"string"},"systemDescriptionLong":{"type":"string"},"serverPlatform":{"type":"string"},"serverOSVersion":{"type":"string"},"fileManagmentSystemType":{"type":"string"},"fileLocation":{"type":"string"},"release":{"type":"string"},"totalTableCount":{"type":"integer","format":"int32"},"totalDBSizeInGB":{"type":"string"},"endOfDayDefinition":{"type":"string"},"dailyBatchExtractWindow":{"type":"string"},"averageNamedUsersCount":{"type":"integer","format":"int32"},"averageConcurrentUsersCount":{"type":"integer","format":"int32"},"specialInsructionsComments":{"type":"string"},"systemOwnerFullName":{"type":"string"},"systemOwnerTelephone":{"type":"string"},"systemOwnerEmail":{"type":"string"},"dataStewardName":{"type":"string","deprecated":true},"dataProfileScoreId":{"type":"integer","format":"int32"},"dataProfileScore":{"type":"string"},"sdiFlag":{"type":"boolean"},"sdiClassificationId":{"type":"integer","format":"int32"},"sdiclassifications":{"type":"array","items":{"$ref":"#/components/schemas/SDIClassification"}},"sdiDescription":{"type":"string"},"sdiClassificationName":{"type":"string"},"esbPlatformType":{"type":"string"},"esbQManagerName":{"type":"string"},"dbmsPlatform":{"type":"string"},"dbmsVersion":{"type":"string"},"objectTypeId":{"type":"integer","format":"int32"}},"xml":{"name":"system"}},"SMEnvironment":{"type":"object","properties":{"endPointType":{"type":"string","enum":["SOURCE","TARGET","BOTH","NONE"]},"nodeId":{"type":"string"},"nodeType":{"type":"string","enum":["MM_PROJECT","MM_SUBJECT","MM_MAPPING","MM_MAPPING_ROW","SM_METADATA","SM_SYSTEM","SM_ENVIRONMENT","SM_TABLE","SM_COLUMN","CSM_CODESET_CATEGORY","CSM_CODESET","REQM_SPECIFICATION","BGM_TERM","BGM_RULE","BGM_POLICY","BGM_CUSTOM","ADS_KEY_VALUE","CSM_CODE_VALUE","TAG","RSM_ROLE","ANY","BUSINESS_ENTITY_TYPE","DI_INSTANCE","LANGUAGE_KEY","APP_PREFERENCE","LINEAGE","BGM_CUSTOM_TYPES"]},"systemId":{"type":"integer","format":"int32"},"systemEnvironmentType":{"type":"string"},"name":{"type":"string"},"systemName":{"type":"string"},"databaseIPAddress":{"type":"string"},"databasePort":{"type":"string"},"databaseName":{"type":"string"},"databaseInstanceSchema":{"type":"string"},"intendedUseDescription":{"type":"string"},"specialApprovalContvyInstructions":{"type":"string"},"environmentNotes":{"type":"string"},"databaseUserName":{"type":"string"},"databasePassword":{"type":"string"},"databaseType":{"type":"string"},"databaseURL":{"type":"string"},"databaseDriver":{"type":"string"},"lastLoadingTime":{"type":"string","format":"date-time"},"userId":{"type":"string"},"databaseDomain":{"type":"string"},"modelFile":{"type":"string"},"modelFileName":{"type":"string"},"dataFileName":{"type":"string"},"passwordEncrypted":{"type":"boolean"},"fileManagementSystemType":{"type":"string"},"fileLocation":{"type":"string"},"productionSystemId":{"type":"string","example":"0"},"productionSystemName":{"type":"string"},"productionEnvironmentName":{"type":"string"},"displayTablesInScan":{"type":"boolean"},"displayViewsInScan":{"type":"boolean"},"displaySynonymsInScan":{"type":"boolean"},"status":{"type":"string"},"systemNumber":{"type":"string","example":"0"},"sapDestination":{"type":"string"},"sapClient":{"type":"string","example":"0"},"fieldDelimiter":{"type":"string"},"rowDelimiter":{"type":"string"},"sapScanTables":{"type":"string"},"systemEnvironmentId":{"type":"integer","format":"int32"},"maximumNoOfConnectionsPerPartition":{"type":"integer","format":"int32"},"minimumNoOfConnectionsPerPartition":{"type":"integer","format":"int32"},"noOfPartitions":{"type":"integer","format":"int32"},"environmentId":{"type":"integer","format":"int32"},"dataStewardName":{"type":"string","deprecated":true},"dataStewardChecked":{"type":"boolean"},"databasePoolType":{"type":"string"},"databaseOptions":{"type":"string"},"environmentType":{"type":"string","enum":["Excel","ETL","CWM","XMI","ERWin","ERWin9","Access","DSV","JSON","XSD","SqlServer","Oracle","SqlServerWindows","GreenPlum","Postgresql","Teradata","Vertica","Pervasive","DB2","MySQL","Sybase","SAP","BigDataCloudera","BigDataHortonWorks","BigDataMapR","Netezza","AmazonRedshift","Salesforce","Snowflake","Databricks","BigQuery","Other","None"]},"version":{"type":"string","example":"1.0"},"versionLabel":{"type":"string"},"changeDescription":{"type":"string"},"sshPort":{"type":"integer","format":"int32"},"authenticationType":{"type":"string"},"kerberosPrincipal":{"type":"string"},"workflowStatus":{"type":"string"},"visibility":{"type":"integer","format":"int32"},"dataProfileScoreId":{"type":"integer","format":"int32"},"dataProfileScore":{"type":"string"},"draft":{"type":"integer","format":"int32"},"sdiFlag":{"type":"boolean"},"rsaKeyPairFlag":{"type":"boolean","example":false},"dqToolProfileId":{"type":"string","deprecated":true},"dataQualityScore":{"type":"number","format":"float"},"impactScore":{"type":"number","format":"float","deprecated":true},"dqToolFlag":{"type":"integer","format":"int32"},"businessEntityType":{"type":"string"},"sdiClassificationId":{"type":"integer","format":"int32"},"sdiclassifications":{"type":"array","items":{"$ref":"#/components/schemas/SDIClassification"}},"sdiDescription":{"type":"string"},"sdiClassificationName":{"type":"string"},"systemEnvironmentName":{"type":"string"},"serverPlatform":{"type":"string"},"serverOSVersion":{"type":"string"},"objectTypeId":{"type":"integer","format":"int32"}},"xml":{"name":"environment"}},"SMColumn":{"type":"object","properties":{"endPointType":{"type":"string","enum":["SOURCE","TARGET","BOTH","NONE"]},"nodeId":{"type":"string"},"nodeType":{"type":"string","enum":["MM_PROJECT","MM_SUBJECT","MM_MAPPING","MM_MAPPING_ROW","SM_METADATA","SM_SYSTEM","SM_ENVIRONMENT","SM_TABLE","SM_COLUMN","CSM_CODESET_CATEGORY","CSM_CODESET","REQM_SPECIFICATION","BGM_TERM","BGM_RULE","BGM_POLICY","BGM_CUSTOM","ADS_KEY_VALUE","CSM_CODE_VALUE","TAG","RSM_ROLE","ANY","BUSINESS_ENTITY_TYPE","DI_INSTANCE","LANGUAGE_KEY","APP_PREFERENCE","LINEAGE","BGM_CUSTOM_TYPES"]},"columnId":{"type":"integer","format":"int32"},"tableId":{"type":"integer","format":"int32"},"tableName":{"type":"string"},"columnName":{"type":"string"},"columnDatatype":{"type":"string"},"storageType":{"type":"string"},"columnLength":{"type":"string"},"columnPrecision":{"type":"string"},"columnDBDefaultValue":{"type":"string"},"columnETLDefaultValue":{"type":"string"},"columnIdentityFlag":{"type":"boolean"},"columnDefinition":{"type":"string"},"columnNullableFlag":{"type":"boolean"},"minimumValue":{"type":"string"},"maximumValue":{"type":"string"},"percentNullValue":{"type":"string"},"columnScale":{"type":"string"},"primaryKeyFlag":{"type":"boolean"},"naturalKeyFlag":{"type":"boolean"},"foreignKeyFlag":{"type":"boolean"},"foreignKeyTableName":{"type":"string"},"foreignKeyColumnName":{"type":"string"},"columnDataDomain":{"type":"string"},"logicalColumnName":{"type":"string"},"physicalColumnName":{"type":"string"},"expandedLogicalName":{"type":"string"},"elnExpanded":{"type":"boolean"},"associatedBusinessTerm":{"type":"string"},"associatedBusinessTermId":{"type":"integer","format":"int32"},"dataProfileScoreId":{"type":"integer","format":"int32"},"dataProfileScore":{"type":"string"},"includeInDataProfile":{"type":"string"},"dataProfileJobState":{"type":"string"},"dataProfileJobFailReason":{"type":"string"},"dataProfileStartDate":{"type":"string"},"dataProfileEndDate":{"type":"string"},"systemName":{"type":"string"},"environmentName":{"type":"string"},"valid":{"type":"boolean"},"insertOrder":{"type":"integer","format":"int32"},"columnComments":{"type":"string"},"columnReferenceId":{"type":"string"},"usedInGapAnalysis":{"type":"boolean"},"userDefined1":{"type":"string"},"userDefined2":{"type":"string"},"userDefined3":{"type":"string"},"userDefined4":{"type":"string"},"userDefined5":{"type":"string"},"userDefined6":{"type":"string"},"userDefined7":{"type":"string"},"userDefined8":{"type":"string"},"userDefined9":{"type":"string"},"userDefined10":{"type":"string"},"fileStartingPosition":{"type":"string"},"columnClass":{"type":"string"},"businessKeyFlag":{"type":"boolean"},"columnAlias":{"type":"string"},"status":{"type":"string"},"workflowStatus":{"type":"string"},"dataStewardName":{"type":"string","deprecated":true},"declarationPath":{"type":"string"},"environmentId":{"type":"integer","format":"int32"},"metadataSource":{"type":"string"},"dqToolProfileId":{"type":"string","deprecated":true},"dataQualityScore":{"type":"number","format":"float"},"impactScore":{"type":"number","format":"float","deprecated":true},"driftAlert":{"type":"string","deprecated":true},"sdiclassifications":{"type":"array","items":{"$ref":"#/components/schemas/SDIClassification"}},"columnType":{"type":"string","enum":["ENTITY","ENTITY_ATTRIBUTE","ENTITY_ELEMENT","FIELD"]},"xpath":{"type":"string"},"stcmid":{"type":"integer","format":"int32"},"sdiClassificationName":{"type":"string"},"sdiClassificationId":{"type":"string"},"sdiDescription":{"type":"string"},"sdiFlag":{"type":"boolean"},"objectTypeId":{"type":"integer","format":"int32"}},"xml":{"name":"column"}},"Tag":{"type":"object","properties":{"endPointType":{"type":"string","enum":["SOURCE","TARGET","BOTH","NONE"]},"nodeId":{"type":"string"},"nodeType":{"type":"string","enum":["MM_PROJECT","MM_SUBJECT","MM_MAPPING","MM_MAPPING_ROW","SM_METADATA","SM_SYSTEM","SM_ENVIRONMENT","SM_TABLE","SM_COLUMN","CSM_CODESET_CATEGORY","CSM_CODESET","REQM_SPECIFICATION","BGM_TERM","BGM_RULE","BGM_POLICY","BGM_CUSTOM","ADS_KEY_VALUE","CSM_CODE_VALUE","TAG","RSM_ROLE","ANY","BUSINESS_ENTITY_TYPE","DI_INSTANCE","LANGUAGE_KEY","APP_PREFERENCE","LINEAGE","BGM_CUSTOM_TYPES"]},"id":{"type":"integer","format":"int32"},"name":{"type":"string"},"description":{"type":"string"},"published":{"type":"boolean"},"scopeObjectTypes":{"type":"array","items":{"type":"string"}},"objectTypeId":{"type":"integer","format":"int32"}}},"Association":{"type":"object","properties":{"id":{"type":"integer","format":"int32"},"sourceObjectId":{"type":"integer","format":"int32"},"sourceObjectTypeId":{"type":"integer","format":"int32"},"targetObjectId":{"type":"integer","format":"int32"},"targetObjectTypeId":{"type":"integer","format":"int32"},"qualifierObjectId":{"type":"integer","format":"int32"},"qualifierObjectTypeId":{"type":"integer","format":"int32"},"fields":{"type":"object","additionalProperties":{"type":"object"}},"relationship":{"$ref":"#/components/schemas/Relationship"}}},"Relationship":{"type":"object","properties":{"id":{"type":"integer","format":"int32"},"masterId":{"type":"integer","format":"int32"},"titleForward":{"type":"string"},"titleReverse":{"type":"string"},"description":{"type":"string"},"definedBy":{"type":"string","enum":["SYSTEM","USER"]},"relationshipType":{"type":"string","enum":["FORWARD","REVERSE","BOTH"]}}},"Subject":{"type":"object","properties":{"endPointType":{"type":"string","enum":["SOURCE","TARGET","BOTH","NONE"]},"nodeId":{"type":"string"},"nodeType":{"type":"string","enum":["MM_PROJECT","MM_SUBJECT","MM_MAPPING","MM_MAPPING_ROW","SM_METADATA","SM_SYSTEM","SM_ENVIRONMENT","SM_TABLE","SM_COLUMN","CSM_CODESET_CATEGORY","CSM_CODESET","REQM_SPECIFICATION","BGM_TERM","BGM_RULE","BGM_POLICY","BGM_CUSTOM","ADS_KEY_VALUE","CSM_CODE_VALUE","TAG","RSM_ROLE","ANY","BUSINESS_ENTITY_TYPE","DI_INSTANCE","LANGUAGE_KEY","APP_PREFERENCE","LINEAGE","BGM_CUSTOM_TYPES"]},"subjectId":{"type":"integer","format":"int32"},"subjectName":{"type":"string"},"subjectDescription":{"type":"string"},"subjectChangedDescription":{"type":"string"},"projectId":{"type":"integer","format":"int32"},"parentSubjectId":{"type":"integer","format":"int32"},"userDefined1":{"type":"string"},"userDefined2":{"type":"string"},"userDefined3":{"type":"string"},"userDefined4":{"type":"string"},"userDefined5":{"type":"string"},"userDefined6":{"type":"string"},"userDefined7":{"type":"string"},"userDefined8":{"type":"string"},"userDefined9":{"type":"string"},"userDefined10":{"type":"string"},"userDefined11":{"type":"string"},"userDefined12":{"type":"string"},"userDefined13":{"type":"string"},"userDefined14":{"type":"string"},"userDefined15":{"type":"string"},"considerUserDefinedFlag":{"type":"string"},"objectTypeId":{"type":"integer","format":"int32"}},"xml":{"name":"subject"}},"Project":{"type":"object","properties":{"endPointType":{"type":"string","enum":["SOURCE","TARGET","BOTH","NONE"]},"nodeId":{"type":"string"},"nodeType":{"type":"string","enum":["MM_PROJECT","MM_SUBJECT","MM_MAPPING","MM_MAPPING_ROW","SM_METADATA","SM_SYSTEM","SM_ENVIRONMENT","SM_TABLE","SM_COLUMN","CSM_CODESET_CATEGORY","CSM_CODESET","REQM_SPECIFICATION","BGM_TERM","BGM_RULE","BGM_POLICY","BGM_CUSTOM","ADS_KEY_VALUE","CSM_CODE_VALUE","TAG","RSM_ROLE","ANY","BUSINESS_ENTITY_TYPE","DI_INSTANCE","LANGUAGE_KEY","APP_PREFERENCE","LINEAGE","BGM_CUSTOM_TYPES"]},"projectId":{"type":"integer","format":"int32"},"projectName":{"type":"string"},"projectDescription":{"type":"string"},"projectCostCenter":{"type":"string"},"projectITSponsorFullName":{"type":"string"},"projectBusinessSponsorFullName":{"type":"string"},"projectOwnerFullName":{"type":"string"},"projectETL":{"type":"string","example":"INFORMATICA_PSEUDOCODE","enum":["BODS_PSEUDOCODE","DATASTAGE_PSEUDOCODE","TALEND_PSEUDOCODE","ODI_PSEUDOCODE","SISI_PSEUDOCODE","INFORMATICA_PSEUDOCODE"]},"objectTypeId":{"type":"integer","format":"int32"}},"xml":{"name":"project"}},"Document":{"type":"object","properties":{"documentName":{"type":"string"},"documentType":{"type":"string"},"documentIntendedPurpose":{"type":"string"},"documentOwner":{"type":"string"},"documentId":{"type":"integer","format":"int32"},"documentObject":{"type":"string"},"documentReference":{"type":"string"},"documentReferenceNumber":{"type":"string"},"approvalRequired":{"type":"boolean"},"documentApprovedBy":{"type":"string"},"documentApprovedDate":{"type":"string","format":"date-time"},"documentStatus":{"type":"string"},"documentLink":{"type":"string"},"filePathType":{"type":"string","enum":["ABSOLUTE","RELATIVE"]}}},"KeyValue":{"type":"object","properties":{"id":{"type":"integer","format":"int32"},"parentId":{"type":"integer","format":"int32"},"childId":{"type":"integer","format":"int32"},"key":{"type":"string"},"value":{"type":"string"},"valueRefId":{"type":"string"},"objectId":{"type":"string"},"objectTypeId":{"type":"string"},"parentObjectId":{"type":"string"},"parentObjectTypeId":{"type":"string","example":"-1"},"description":{"type":"string"},"regularExpression":{"type":"string"},"order":{"type":"number","format":"float"},"purge":{"type":"boolean"},"processingOrder":{"type":"integer","format":"int32"},"fieldLength":{"type":"integer","format":"int32"},"fieldType":{"type":"string"},"component":{"type":"string"},"keyStyle":{"type":"string"},"valueStyle":{"type":"string"},"defaultValue":{"type":"string"},"published":{"type":"boolean"},"systemBased":{"type":"boolean"},"fromParent":{"type":"boolean"},"fromChild":{"type":"boolean"},"fetchOnlyParent":{"type":"boolean"},"enabled":{"type":"boolean"},"cellType":{"type":"string"},"consolidated":{"type":"boolean"},"expand":{"type":"boolean"},"displayPolicy":{"type":"integer","format":"int32"},"parentKey":{"type":"string"},"keyValues":{"type":"array","items":{"$ref":"#/components/schemas/KeyValue"}},"objectStyle":{"type":"string"},"html":{"type":"boolean"},"htmlDisabled":{"type":"boolean"},"formatRefValues":{"type":"boolean"},"loadonStartup":{"type":"integer","format":"int32"},"mode":{"type":"string"},"objectLevel":{"type":"integer","format":"int32"},"formProperty":{"type":"integer","format":"int32"},"gridProperty":{"type":"integer","format":"int32"},"pivoTable":{"type":"integer","format":"int32"},"discoverAssetProperty":{"type":"integer","format":"int32"},"uitype":{"type":"string","example":"TEXTBOX","enum":["Label","Text Box","Text Area","Number","Boolean","Check Box","Date Picker","Color Picker","Radio","List","Combo Box","combovalues","Rich Editor"]},"uiType":{"type":"string","example":"TEXTBOX","enum":["Label","Text Box","Text Area","Number","Boolean","Check Box","Date Picker","Color Picker","Radio","List","Combo Box","combovalues","Rich Editor"]},"mandatory":{"type":"boolean"},"visibility":{"type":"integer","format":"int32"},"text":{"type":"string"},"pref_type":{"type":"string"},"type":{"type":"string"},"selectedValue":{"type":"string"},"tooltip":{"type":"string"}}},"Mapping":{"type":"object","properties":{"endPointType":{"type":"string","enum":["SOURCE","TARGET","BOTH","NONE"]},"nodeId":{"type":"string"},"nodeType":{"type":"string","enum":["MM_PROJECT","MM_SUBJECT","MM_MAPPING","MM_MAPPING_ROW","SM_METADATA","SM_SYSTEM","SM_ENVIRONMENT","SM_TABLE","SM_COLUMN","CSM_CODESET_CATEGORY","CSM_CODESET","REQM_SPECIFICATION","BGM_TERM","BGM_RULE","BGM_POLICY","BGM_CUSTOM","ADS_KEY_VALUE","CSM_CODE_VALUE","TAG","RSM_ROLE","ANY","BUSINESS_ENTITY_TYPE","DI_INSTANCE","LANGUAGE_KEY","APP_PREFERENCE","LINEAGE","BGM_CUSTOM_TYPES"]},"mappingId":{"type":"integer","format":"int32"},"mappingName":{"type":"string"},"mappingDescription":{"type":"string"},"mappingSpecVersion":{"type":"number","format":"float"},"projectId":{"type":"integer","format":"int32"},"subjectId":{"type":"integer","format":"int32"},"sourceExtractQuery":{"type":"string"},"sourceExtractDescription":{"type":"string"},"targetUpdateStrategy":{"type":"string","example":"US"},"targetUpgateStrategyNotes":{"type":"string"},"testDisposition":{"type":"string","example":"U"},"testingNotes":{"type":"string"},"mappingStatus":{"type":"string","example":"Active"},"versionLabel":{"type":"string"},"changedDescription":{"type":"string"},"actualDevelopLevelOfEffort":{"type":"string"},"actualNotes":{"type":"string"},"plannedDevelopmentLevelOfEffort":{"type":"string"},"plannedNotes":{"type":"string"},"plannedMappingEffort":{"type":"number","format":"float"},"plannedMappingEffortUnits":{"type":"string"},"plannedETLEffort":{"type":"number","format":"float"},"plannedETLEffortUnits":{"type":"string"},"actualMappingEffort":{"type":"number","format":"float"},"actualMappingEffortUnits":{"type":"string"},"actualETLEffort":{"type":"number","format":"float"},"actualETLEffortUnits":{"type":"string"},"jobXRef":{"type":"string"},"updateSourceMetadata":{"type":"boolean"},"updateTargetMetadata":{"type":"boolean"},"userDefined1":{"type":"string"},"userDefined2":{"type":"string"},"userDefined3":{"type":"string"},"userDefined4":{"type":"string"},"userDefined5":{"type":"string"},"userDefined6":{"type":"string"},"userDefined7":{"type":"string"},"userDefined8":{"type":"string"},"userDefined9":{"type":"string"},"userDefined10":{"type":"string"},"userDefined11":{"type":"string"},"userDefined12":{"type":"string"},"userDefined13":{"type":"string"},"userDefined14":{"type":"string"},"userDefined15":{"type":"string"},"userDefined16":{"type":"string"},"userDefined17":{"type":"string"},"userDefined18":{"type":"string"},"userDefined19":{"type":"string"},"userDefined20":{"type":"string"},"userDefined21":{"type":"string"},"userDefined22":{"type":"string"},"userDefined23":{"type":"string"},"userDefined24":{"type":"string"},"userDefined25":{"type":"string"},"userDefined26":{"type":"string"},"userDefined27":{"type":"string"},"userDefined28":{"type":"string"},"userDefined29":{"type":"string"},"userDefined30":{"type":"string"},"userDefined31":{"type":"string"},"userDefined32":{"type":"string"},"userDefined33":{"type":"string"},"userDefined34":{"type":"string"},"userDefined35":{"type":"string"},"userDefined36":{"type":"string"},"userDefined37":{"type":"string"},"userDefined38":{"type":"string"},"userDefined39":{"type":"string"},"userDefined40":{"type":"string"},"userDefined41":{"type":"string"},"userDefined42":{"type":"string"},"userDefined43":{"type":"string"},"userDefined44":{"type":"string"},"userDefined45":{"type":"string"},"published":{"type":"boolean"},"publishNotes":{"type":"string"},"effectiveDate":{"type":"string","format":"date-time"},"mappingSpecifications":{"type":"array","items":{"$ref":"#/components/schemas/MappingSpecificationRow"}},"mappingDocuments":{"type":"array","items":{"$ref":"#/components/schemas/Document"}},"mappingStateId":{"type":"integer","format":"int32"},"mappingStateName":{"type":"string"},"mappingSubStateId":{"type":"integer","format":"int32"},"mappingSubStateName":{"type":"string"},"extendedProperties":{"type":"array","items":{"$ref":"#/components/schemas/KeyValue"}},"objectTypeId":{"type":"integer","format":"int32"}},"xml":{"name":"mapping"}},"MappingSpecificationRow":{"type":"object","properties":{"endPointType":{"type":"string","enum":["SOURCE","TARGET","BOTH","NONE"]},"nodeId":{"type":"string"},"nodeType":{"type":"string","enum":["MM_PROJECT","MM_SUBJECT","MM_MAPPING","MM_MAPPING_ROW","SM_METADATA","SM_SYSTEM","SM_ENVIRONMENT","SM_TABLE","SM_COLUMN","CSM_CODESET_CATEGORY","CSM_CODESET","REQM_SPECIFICATION","BGM_TERM","BGM_RULE","BGM_POLICY","BGM_CUSTOM","ADS_KEY_VALUE","CSM_CODE_VALUE","TAG","RSM_ROLE","ANY","BUSINESS_ENTITY_TYPE","DI_INSTANCE","LANGUAGE_KEY","APP_PREFERENCE","LINEAGE","BGM_CUSTOM_TYPES"]},"mappingSequenceId":{"type":"integer","format":"int32"},"mappingId":{"type":"integer","format":"int32"},"sourceSystemId":{"type":"integer","format":"int32"},"sourceSystemName":{"type":"string"},"sourceSystemEnvironmentName":{"type":"string"},"sourceTableName":{"type":"string"},"sourceColumnName":{"type":"string"},"sourceColumnDatatype":{"type":"string"},"sourceColumnDBDefaultValue":{"type":"string"},"sourceColumnDefinition":{"type":"string"},"sourceColumnIdentityFlag":{"type":"boolean"},"sourceColumnNullableFlag":{"type":"boolean"},"sourcePercentNullValue":{"type":"string"},"sourceNaturalKeyFlag":{"type":"boolean"},"sourcePrimaryKeyFlag":{"type":"boolean"},"sourceSDIFlag":{"type":"boolean"},"sourceSDIDescription":{"type":"string"},"sourceLogicalColumnName":{"type":"string"},"sourceColumnComments":{"type":"string"},"sourceXPath":{"type":"string"},"baseSourceSystemEnvironmentName":{"type":"string"},"baseSourceSystemName":{"type":"string"},"sourceTableClass":{"type":"string"},"sourceColumnClass":{"type":"string"},"sourceBusinessKeyFlag":{"type":"boolean"},"sourceTableAlias":{"type":"string"},"sourceColumnAlias":{"type":"string"},"targetSystemId":{"type":"integer","format":"int32"},"targetSystemName":{"type":"string"},"targetSystemEnvironmentName":{"type":"string"},"targetTableName":{"type":"string"},"targetColumnName":{"type":"string"},"targetColumnDatatype":{"type":"string"},"targetColumnETLDefaultValue":{"type":"string"},"targetColumnDefinition":{"type":"string"},"targetNaturalKeyFlag":{"type":"boolean"},"targetPrimaryKeyFlag":{"type":"boolean"},"targetColumnNullableFlag":{"type":"boolean"},"targetSDIFlag":{"type":"boolean"},"targetSDIDescription":{"type":"string"},"targetLogicalColumnName":{"type":"string"},"targetColumnComments":{"type":"string"},"targetXPath":{"type":"string"},"baseTargetSystemEnvironmentName":{"type":"string"},"baseTargetSystemName":{"type":"string"},"targetColumnAlias":{"type":"string"},"targetBusinessKeyFlag":{"type":"boolean"},"targetTableAlias":{"type":"string"},"targetColumnClass":{"type":"string"},"targetTableClass":{"type":"string"},"businessRule":{"type":"string"},"extendedBusinessRule":{"type":"string"},"pseudocode":{"type":"string"},"columnMappingCompleteFlag":{"type":"boolean"},"userDefined1":{"type":"string"},"userDefined2":{"type":"string"},"userDefined3":{"type":"string"},"userDefined4":{"type":"string"},"userDefined5":{"type":"string"},"userDefined6":{"type":"string"},"userDefined7":{"type":"string"},"userDefined8":{"type":"string"},"userDefined9":{"type":"string"},"userDefined10":{"type":"string"},"userDefined11":{"type":"string"},"userDefined12":{"type":"string"},"userDefined13":{"type":"string"},"userDefined14":{"type":"string"},"userDefined15":{"type":"string"},"userDefined16":{"type":"string"},"userDefined17":{"type":"string"},"userDefined18":{"type":"string"},"userDefined19":{"type":"string"},"userDefined20":{"type":"string"},"userDefined21":{"type":"string"},"userDefined22":{"type":"string"},"userDefined23":{"type":"string"},"userDefined24":{"type":"string"},"userDefined25":{"type":"string"},"userDefined26":{"type":"string"},"userDefined27":{"type":"string"},"userDefined28":{"type":"string"},"userDefined29":{"type":"string"},"userDefined30":{"type":"string"},"userDefined31":{"type":"string"},"userDefined32":{"type":"string"},"userDefined33":{"type":"string"},"userDefined34":{"type":"string"},"userDefined35":{"type":"string"},"userDefined36":{"type":"string"},"userDefined37":{"type":"string"},"userDefined38":{"type":"string"},"userDefined39":{"type":"string"},"userDefined40":{"type":"string"},"userDefined41":{"type":"string"},"userDefined42":{"type":"string"},"userDefined43":{"type":"string"},"userDefined44":{"type":"string"},"userDefined45":{"type":"string"},"userDefined46":{"type":"string"},"userDefined47":{"type":"string"},"userDefined48":{"type":"string"},"userDefined49":{"type":"string"},"userDefined50":{"type":"string"},"specificationArtifacts":{"type":"string"},"rdmReferenceTable":{"type":"string"},"mappingSpecificationRowComments":{"type":"string"},"lookupOn":{"type":"string"},"transformationLookupCondition":{"type":"string"},"lookupColumn":{"type":"string"},"rowOrder":{"type":"number","format":"float"},"sourceTableType":{"type":"string"},"targetTableType":{"type":"string"},"targetEntityUID":{"type":"string"},"sourceEntityUID":{"type":"string"},"sourceEnvBusinessEntityType":{"type":"string"},"sourceTableBusinessEntityType":{"type":"string"},"targetEnvBusinessEntityType":{"type":"string"},"targetTableBusinessEntityType":{"type":"string"},"csmmappingReference":{"type":"string"},"sourceColumnLength":{"type":"string"},"sourceColumnPrecision":{"type":"string"},"sourceColumnScale":{"type":"string"},"sourceMinimumValue":{"type":"string"},"sourceMaximumValue":{"type":"string"},"targetColumnLength":{"type":"string"},"targetColumnPrecision":{"type":"string"},"targetColumnScale":{"type":"string"},"objectTypeId":{"type":"integer","format":"int32"}},"xml":{"name":"mappingSpecificationRow"}},"AssetType":{"type":"object","properties":{"endPointType":{"type":"string","enum":["SOURCE","TARGET","BOTH","NONE"]},"nodeId":{"type":"string"},"nodeType":{"type":"string","enum":["MM_PROJECT","MM_SUBJECT","MM_MAPPING","MM_MAPPING_ROW","SM_METADATA","SM_SYSTEM","SM_ENVIRONMENT","SM_TABLE","SM_COLUMN","CSM_CODESET_CATEGORY","CSM_CODESET","REQM_SPECIFICATION","BGM_TERM","BGM_RULE","BGM_POLICY","BGM_CUSTOM","ADS_KEY_VALUE","CSM_CODE_VALUE","TAG","RSM_ROLE","ANY","BUSINESS_ENTITY_TYPE","DI_INSTANCE","LANGUAGE_KEY","APP_PREFERENCE","LINEAGE","BGM_CUSTOM_TYPES"]},"id":{"type":"integer","format":"int32"},"catalogTypeId":{"type":"integer","format":"int32"},"catalogsTypeId":{"type":"integer","format":"int32"},"name":{"type":"string"},"title":{"type":"string"},"description":{"type":"string"},"color":{"type":"string"},"module":{"type":"string","example":"BUSINESS_GLOSSARY_MANAGER","enum":["com.ads.mm.permission.mm","com.ads.mm.permission.sm","com.ads.mm.permission.rsm","com.ads.mm.permission.cm","com.ads.mm.permission.rm","com.ads.mm.permission.rdm","com.ads.mm.permission.cat","com.ads.mm.permission.tm","com.ads.mm.permission.rqm","com.ads.mm.permission.rpm","com.ads.mm.permission.bgm","com.ads.mm.permission.workflow","com.ads.mm.permission.autom","com.ads.mm.permission.datamarketplace","com.ads.mm.permission.unknown"]},"documentsRequired":{"type":"boolean"},"enabled":{"type":"boolean"},"definitionEnabled":{"type":"boolean"},"sdiEnabled":{"type":"boolean"},"systemBased":{"type":"boolean"},"displayOrder":{"type":"number","format":"float"},"objectTypeId":{"type":"integer","format":"int32"}},"xml":{"name":"assetType"}},"BusinessObject":{"type":"object","properties":{"endPointType":{"type":"string","enum":["SOURCE","TARGET","BOTH","NONE"]},"nodeId":{"type":"string"},"nodeType":{"type":"string","enum":["MM_PROJECT","MM_SUBJECT","MM_MAPPING","MM_MAPPING_ROW","SM_METADATA","SM_SYSTEM","SM_ENVIRONMENT","SM_TABLE","SM_COLUMN","CSM_CODESET_CATEGORY","CSM_CODESET","REQM_SPECIFICATION","BGM_TERM","BGM_RULE","BGM_POLICY","BGM_CUSTOM","ADS_KEY_VALUE","CSM_CODE_VALUE","TAG","RSM_ROLE","ANY","BUSINESS_ENTITY_TYPE","DI_INSTANCE","LANGUAGE_KEY","APP_PREFERENCE","LINEAGE","BGM_CUSTOM_TYPES"]},"fields":{"type":"object","additionalProperties":{"type":"object"}},"catalogId":{"type":"integer","format":"int32"},"id":{"type":"integer","format":"int32"},"name":{"type":"string"},"definition":{"type":"string"},"description":{"type":"string"},"workflowStatus":{"type":"string"},"sdiFlag":{"type":"boolean"},"assetType":{"$ref":"#/components/schemas/AssetType"},"sdiclassifications":{"type":"array","items":{"$ref":"#/components/schemas/SDIClassification"}},"objectTypeId":{"type":"integer","format":"int32"}},"xml":{"name":"businessObject"},"discriminator":{"propertyName":"nodeType"}},"BusinessPolicy":{"type":"object","xml":{"name":"businessPolicy"},"allOf":[{"$ref":"#/components/schemas/BusinessObject"},{"type":"object","properties":{"status":{"type":"string"},"notes":{"type":"string"},"policyStartDate":{"type":"string"},"policyEndDate":{"type":"string"},"userDefinedField1":{"type":"string"},"userDefinedField2":{"type":"string"},"userDefinedField3":{"type":"string"},"userDefinedField4":{"type":"string"},"userDefinedField5":{"type":"string"},"userDefinedField6":{"type":"string"},"userDefinedField7":{"type":"string"},"userDefinedField8":{"type":"string"},"userDefinedField9":{"type":"string"},"userDefinedField10":{"type":"string"},"expiryType":{"type":"string","enum":["NONE","No Expiry","Limited Duration"]},"publish":{"type":"string"}}}]},"BusinessRule":{"type":"object","xml":{"name":"businessRule"},"allOf":[{"$ref":"#/components/schemas/BusinessObject"},{"type":"object","properties":{"objective":{"type":"string"},"status":{"type":"string"},"notes":{"type":"string"},"criticality":{"type":"string"},"publish":{"type":"string"}}}]},"BusinessTerm":{"type":"object","xml":{"name":"businessTerm"},"allOf":[{"$ref":"#/components/schemas/BusinessObject"},{"type":"object","properties":{"notes":{"type":"string"},"status":{"type":"string"},"dataClassificationType":{"type":"string"},"acronym":{"type":"string"},"valid":{"type":"boolean"},"dataObjectType":{"type":"string"},"dataCollectionType":{"type":"string"},"meaningCategoryType":{"type":"string"},"userDefinedField1":{"type":"string"},"userDefinedField2":{"type":"string"},"userDefinedField3":{"type":"string"},"userDefinedField4":{"type":"string"},"userDefinedField5":{"type":"string"},"userDefinedField6":{"type":"string"},"userDefinedField7":{"type":"string"},"userDefinedField8":{"type":"string"},"userDefinedField9":{"type":"string"},"userDefinedField10":{"type":"string"},"published":{"type":"boolean"}}}]},"Catalog":{"type":"object","properties":{"endPointType":{"type":"string","enum":["SOURCE","TARGET","BOTH","NONE"]},"nodeId":{"type":"string"},"nodeType":{"type":"string","enum":["MM_PROJECT","MM_SUBJECT","MM_MAPPING","MM_MAPPING_ROW","SM_METADATA","SM_SYSTEM","SM_ENVIRONMENT","SM_TABLE","SM_COLUMN","CSM_CODESET_CATEGORY","CSM_CODESET","REQM_SPECIFICATION","BGM_TERM","BGM_RULE","BGM_POLICY","BGM_CUSTOM","ADS_KEY_VALUE","CSM_CODE_VALUE","TAG","RSM_ROLE","ANY","BUSINESS_ENTITY_TYPE","DI_INSTANCE","LANGUAGE_KEY","APP_PREFERENCE","LINEAGE","BGM_CUSTOM_TYPES"]},"catalogId":{"type":"integer","format":"int32"},"parentCatalogId":{"type":"integer","format":"int32"},"catalogName":{"type":"string"},"description":{"type":"string"},"catalogTypeId":{"type":"integer","format":"int32"},"businessObjects":{"type":"array","items":{"oneOf":[{"$ref":"#/components/schemas/BusinessObject"},{"$ref":"#/components/schemas/BusinessPolicy"},{"$ref":"#/components/schemas/BusinessRule"},{"$ref":"#/components/schemas/BusinessTerm"},{"$ref":"#/components/schemas/CustomObject"}]}},"fields":{"type":"object","additionalProperties":{"type":"object"}},"objectTypeId":{"type":"integer","format":"int32"}},"xml":{"name":"catalog"}},"CustomObject":{"type":"object","xml":{"name":"customObject"},"allOf":[{"$ref":"#/components/schemas/BusinessObject"},{"type":"object","properties":{"publish":{"type":"string"},"rating":{"type":"number","format":"double"},"dataValueScore":{"type":"string"}}}]},"DBHelper":{"type":"object","properties":{"dbUrl":{"type":"string"},"dbDriver":{"type":"string"},"dbUserName":{"type":"string"},"dbPassword":{"type":"string"},"dbName":{"type":"string"},"dbSchema":{"type":"string"},"databaseType":{"type":"string","enum":["ERWIN","ETL","ERWIN9","CWM","XMI","XSD","DSV","JSON","EXCEL","MDB","HSQLDB","SQLSERVER","SQLSERVERWINDOWS","ORACLE","GREENPLUM","POSTGRESQL","VERTICA","SYBASE","PERVASIVE","TERADATA","DB2","MYSQL","NETEZZA","SAP","AmazonRedshift","OTHER","ODBC","Cloudera","Hortonworks","MapR","SALESFORCE","Snowflake","Databricks","BigQuery"]},"readColumns":{"type":"boolean"},"readComments":{"type":"boolean"},"readTables":{"type":"boolean"},"readViews":{"type":"boolean"},"readSynonyms":{"type":"boolean"},"scanOptions":{"type":"string"},"readHeader":{"type":"boolean"},"ipAddress":{"type":"string"},"systemNumber":{"type":"string"},"client":{"type":"string"},"destinationName":{"type":"string"},"filePath":{"type":"string"},"filePathType":{"type":"string","enum":["ABSOLUTE","RELATIVE"]},"readLogicalColumns":{"type":"boolean"},"modelType":{"type":"string","enum":["PHYSICAL","LOGICAL","DDL"]},"selectedEntities":{"type":"array","items":{"type":"object"}},"partitions":{"type":"integer","format":"int32"},"minimumConnectionsPerPartition":{"type":"integer","format":"int32","example":3},"maximumConnectionsPerPartition":{"type":"integer","format":"int32","example":5},"testConnectionPeriodically":{"type":"boolean"},"testConnectionQuery":{"type":"string","example":"SELECT 1"},"scanNestedRefSynonyms":{"type":"boolean"},"autoCommit":{"type":"boolean"},"hasAccessToDba":{"type":"boolean"},"queryBatchLimit":{"type":"integer","format":"int32"},"fieldSeparator":{"type":"string"},"rowSeparator":{"type":"string"},"useReferenceId":{"type":"boolean"},"scanCriteria":{"type":"string","enum":["INCLUDE_SELECTION","EXCLUDE_SELECTION","ALL"]},"connectionPoolType":{"type":"string","enum":["HIKARI","BONECP","C3P0"]},"transactionIsolation":{"type":"string"},"readOnly":{"type":"string"},"kerberosPrincipal":{"type":"string"},"sshPort":{"type":"integer","format":"int32"},"selectedTables":{"type":"object","additionalProperties":{"type":"array","items":{"type":"string"}}},"selectedViews":{"type":"object","additionalProperties":{"type":"array","items":{"type":"string"}}},"selectedSynonyms":{"type":"object","additionalProperties":{"type":"array","items":{"type":"string"}}},"updateTableELNFlag":{"type":"boolean"},"updateColumnELNFlag":{"type":"boolean"},"generateSummary":{"type":"boolean"},"validateData":{"type":"boolean"},"parseHiveComplexDataType":{"type":"boolean"},"importSdi":{"type":"boolean"},"importTags":{"type":"boolean"},"importAssociations":{"type":"boolean"},"importExtendedProperties":{"type":"boolean"},"dumpFiles":{"type":"boolean"},"skipEmptyCells":{"type":"boolean"},"supportAutoCommit":{"type":"boolean"},"cwmversion":{"type":"string","enum":["v1_0","v1_1"]}}}},"securitySchemes":{"ApiKeyAuth":{"type":"apiKey","name":"Authorization","in":"header"}}}};